// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OWF/Content.subproj/OWObjectStreamCursor.h,v 1.4 1998/12/08 04:05:44 kc Exp $

#import "OWCursor.h"

@class OWAbstractObjectStream;

@interface OWObjectStreamCursor : OWCursor <NSCopying>
{
    OWAbstractObjectStream *objectStream;
    unsigned int streamIndex;
}

- initForObjectStream:(OWAbstractObjectStream *)anObjectStream;
- (OWAbstractObjectStream *)objectStream;
- (unsigned int)streamIndex;

- (id)readObject;
- (void)skipObjects:(int)count;
- (void)ungetObject:(id)anObject;

@end
