// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OWObjectStreamProcessor.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import "OWObjectStreamCursor.h"
#import "OWPipeline.h"

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OWF/Processors.subproj/OWObjectStreamProcessor.m,v 1.3 1998/12/08 04:05:57 kc Exp $")

@implementation OWObjectStreamProcessor

- initWithPipeline:(OWPipeline *)aPipeline;
{
    if (![super initWithPipeline:aPipeline])
	return nil;

    objectCursor = [[(id <OWOptionalContent>)[pipeline lastContent] contentCursor] retain];

    return self;
}

- (void)dealloc;
{
    [objectCursor release];
    [super dealloc];
}

// OWProcessor subclass

- (void)abortProcessing;
{
    [objectCursor abort];
    [super abortProcessing];
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];

    if (objectCursor)
        [debugDictionary setObject:objectCursor forKey:@"objectCursor"];

    return debugDictionary;
}

@end
