// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OWSourceProcessor.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import "OWContentCache.h"
#import "OWContentContainer.h"
#import "OWContentType.h"
#import "OWDataStream.h"

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OWF/Processors.subproj/OWSourceProcessor.m,v 1.4 1998/12/08 04:05:58 kc Exp $")

static OWContentType *sourceContentType;

@implementation OWSourceProcessor

+ (void)initialize;
{
    static BOOL initialized = NO;

    [super initialize];
    if (initialized)
	return;
    initialized = YES;

    sourceContentType = [OWContentType contentTypeForString:@"Omni/Source"];
}

+ (void)didLoad;
{
    [self registerProcessorClass:self fromContentType:sourceContentType toContentType:[OWContentType wildcardContentType] cost:1.0];
}

+ (OWContentType *)sourceContentType;
{
    return sourceContentType;
}

- initWithPipeline:(OWPipeline *)aPipeline;
{
    OWContentContainer *originalSource;
    id <OWContent> sourceContent;

    if (![super initWithPipeline:aPipeline])
	return nil;

    originalSource = [pipeline lastContent];
    sourceContent = [[originalSource content] retain];
    [pipeline addContent:sourceContent];
    [sourceContent release];
    [pipeline startProcessingContent];

    return self;
}

@end

@implementation OWPipeline (Source)

- (void)addSourceContent:(id <OWContent>)aContent;
{
    OWContentContainer *sourceContent;

    sourceContent = [[OWContentContainer alloc] initWithContent:aContent contentType:sourceContentType];
    [self addContent:sourceContent];
    [sourceContent release];
}

@end
