#import <AppKit/AppKit.h>
#import "Universe.h"
#import "Planet.h"

@class UniverseInspector;

@interface UniverseView : NSView
{
   id inspector;
   id numPlanetsField;
   id numPlanetsSlider;

   int nSteps;
   int maxSteps;
   int numPlanets;
   
   double scale;
   NSRect universeBounds;

   double rScale;
   Universe *universe;

   UniverseInspector *detailedInspector;
   NSColor *backgroundColor;

   BOOL needsFullRefresh;
   BOOL haveUnsavedDefaults;
   BOOL bounce;
}

+ (void)initialize;
- (void)showDetailedInspector:(id)sender;
- (void)setNumPlanets:(id)sender;
- (void)drawRect:(NSRect) rects;
- (id)initWithFrame:(NSRect) frameRect;
- (void)dealloc ;
- (void)setFrameSize:(NSSize)newSize;
- (NSTimeInterval)animationDelayTime;
- (NSView *)inspector:sender;
- (void)clearUniverse;
- (void)drawUniverse;
- (void)oneStep;
- (void)antialiasHack;
- (BOOL)useBufferedWindow;
- (void)drawPlanet:(Planet *)p;
- (void)drawPlanetNoColor:(Planet *)p;
- (Universe *)newUniverseWithBounds:(NSRect)newBounds numPlanets:(int)n;

- (double) scale;
- (void)setScale:(double)s;

- (double)rScale;
- (void)setRScale:(double)rs;

- (BOOL)bounce;
- (void)setBounce:(BOOL)b;

- (void)addPlanets:(int)n inColor:(NSColor *)color;

- (NSColor *)backgroundColor;
- (void)setBackgroundColor:(NSColor *)bgCol;
- (NSColor *)defaultPlanetColor;
- (void)setDefaultPlanetColor:(NSColor *)bgCol;

- (int)maxSteps;
- (void)setMaxSteps:(int)m;

@end
