//---------------------------------------------------------------------------------------
//	PrefController.m created by erik on Fri 03-Jul-1998
//	This code is part of the Spectre Project by Erik Doernenburg. For copyright details
//	see GNU public license version 2 or above. No warranties implied. Use at own risk.
//	More information can be found at <http://www.object-factory.com/~erik/Spectre>.
//	@(#)$Id: PrefController.m,v 1.5 1998/09/27 16:08:33 erik Exp $
//---------------------------------------------------------------------------------------

#import <AppKit/AppKit.h>
#import "PrefController.h"

@interface PrefController(Private)
- (void)_putBoolDefaultForKey:(NSString *)key intoButton:(NSButton *)button;
- (void)_takeBoolDefaultForKey:(NSString *)key fromButton:(NSButton *)button;
@end


//---------------------------------------------------------------------------------------
    @implementation PrefController
//---------------------------------------------------------------------------------------

NSString *SPCDockKey = @"Dock";
NSString *SPCDockLevelKey = @"DockWindowLevel";
NSString *SPCDockOriginKey = @"DockOrigin";
NSString *SPCDockItemsKey = @"DockItems";
NSString *SPCDockDontHideKey = @"DontHideDock";


//---------------------------------------------------------------------------------------
//	INIT
//---------------------------------------------------------------------------------------

- init
{
    NSString		*resourcePath;
    NSDictionary	*factorySettings;

    [super init];

    resourcePath = [[NSBundle mainBundle] pathForResource:@"FactorySettings" ofType:@"plist"];
    NSAssert(resourcePath != nil, @"missing resource; cannot find FactorySettings");
    factorySettings = [[NSString stringWithContentsOfFile:resourcePath] propertyList];
    [[NSUserDefaults standardUserDefaults] registerDefaults:factorySettings];

    return self;
}


//---------------------------------------------------------------------------------------
//	READING AND WRITING THE DEFAULTS
//---------------------------------------------------------------------------------------

- (void)readDefaults:(id)sender;
{    
    [self _putBoolDefaultForKey:SPCDockKey intoButton:showDockButton];
    [floatingDockButton setState:([[NSUserDefaults standardUserDefaults] integerForKey:SPCDockLevelKey] > NSNormalWindowLevel) ? 1 : 0];
    [self _putBoolDefaultForKey:SPCDockDontHideKey intoButton:dontHideDockButton];
}


- (void)writeDefaults:(id)sender;
{
    [self _takeBoolDefaultForKey:SPCDockKey fromButton:showDockButton];
    [[NSUserDefaults standardUserDefaults] setInteger:([floatingDockButton state] == 1) ? NSMainMenuWindowLevel - 1 : NSNormalWindowLevel - 1 forKey:SPCDockLevelKey];
    [self _takeBoolDefaultForKey:SPCDockDontHideKey fromButton:dontHideDockButton];
}


//---------------------------------------------------------------------------------------
//	RUNNING THE PANEL
//---------------------------------------------------------------------------------------

- (void)runModal:(id)sender;
{
    int	choice;
    
    [NSBundle loadNibNamed:@"Preferences" owner:self];
    NSAssert(panel != nil, @"missing resource; cannot find Preferences NIB");

    [self readDefaults:self];
    [panel makeKeyAndOrderFront:self];
    do
        {
        choice = [NSApp runModalForWindow:panel];
        if(choice > 0)
            [self writeDefaults:self];
        }
    while(choice == 2);
    [panel orderOut:self];
    [panel release];
}


- (void)endModalSession:(id)sender;
{
    [NSApp stopModalWithCode:[[sender selectedCell] tag]];
}


//---------------------------------------------------------------------------------------
    @end
//---------------------------------------------------------------------------------------


//---------------------------------------------------------------------------------------
   @implementation PrefController(Private)
//---------------------------------------------------------------------------------------

- (void)_putBoolDefaultForKey:(NSString *)key intoButton:(NSButton *)button;
{
    BOOL value;

    value = [[NSUserDefaults standardUserDefaults] boolForKey:key];
    [button setState:value ? NSOnState : NSOffState];

}


- (void)_takeBoolDefaultForKey:(NSString *)key fromButton:(NSButton *)button;
{
    int	state;

    state = [button state];
    NSAssert(((state == NSOnState) || (state == NSOffState)), @"cannot take bool value from button that is neither on nor off.");
    [[NSUserDefaults standardUserDefaults] setBool:(state == NSOnState) forKey:key];
}


//---------------------------------------------------------------------------------------
   @end
//---------------------------------------------------------------------------------------
