/* Copyright (c) 1992 NeXT Computer, Inc.  All rights reserved.
 *
 *	File:	architecture/ppc/mpc601_regs.h
 *	Author:	Ben Fathi, NeXT Computer, Inc.
 *
 *	MPC601-specific registers
 *
 * HISTORY
 * 31-Jan-97  Kevin Enderby (enderby@next.com)
 *	Changed m98k to ppc.
 *
 * 08-Dec-92  Ben Fathi (benf@next.com)
 *	Added interrpt status registers.
 *
 * 18-Nov-92  Ben Fathi (benf@next.com)
 *	Created.
 */

#ifndef _ARCH_PPC_MPC601_REGS_H_
#define _ARCH_PPC_MPC601_REGS_H_

/*
 * Software definitions for mpc601-specific registers
 */
#define SR_MPC601_MCHECK	hid0	// machine check status
#define SR_MPC601_RMI_MODES	hid1	// run and fetch modes
#define SR_MPC601_RMI_ADDR	hid2	// run mode compare address
#define SR_MPC601_RMI_DABR	hid5	// data address breakpoint
#define SR_MPC601_PID		pid	// processor ID
#define SR_MPC601_MQ		mq	// multiply quotient

/*
 * Data Breakpoints
 */

#define	MPC601_N_DATA_BP	1		// MPC601 supports 1 data bp

/*
 * Data Breakpoint Address Specification (register HID5 aka DABR)
 */
typedef	struct {
	unsigned	addr:BITS_WIDTH(31,3);	// double-word address
	unsigned	rsvd:BIT_WIDTH(2);
	unsigned	w:BIT_WIDTH(1);		// 1 => compare on store
	unsigned	r:BIT_WIDTH(0);		// 1 => compare on load
} mpc601_data_bp_addr_t;

/*
 * Valid values for "run" bits in mpc601_data_bp_mode_t
 */
#define	MPC601_RUN_NORMAL		0
#define MPC601_RUN_LIMITED_ADDR_CMP	2
#define MPC601_RUN_SINGLE_INSTR_STEP	4
#define MPC601_RUN_FULL_ADDR_CMP	6
#define MPC601_RUN_FULL_BRANCH_TARG_CMP	7

/*
 * Valid values for "resp" bits in mpc601_data_bp_mode_t
 */
#define	MPC601_RESP_HARD_STOP		0
#define	MPC601_RESP_SOFT_STOP		1
#define	MPC601_RESP_TRAP		2

/*
 * Data Breakpoint Mode Specification (register HID1)
 */
typedef	struct {
	unsigned	:BIT_WIDTH(31);
	unsigned	run:BITS_WIDTH(30,28);		// see above
	unsigned	:BITS_WIDTH(27,24);
	unsigned	resp:BITS_WIDTH(23,22);		// see above
	unsigned	scan:BIT_WIDTH(21);		// not for sw use
	unsigned	:BITS_WIDTH(20,15);
	unsigned	no_brd_tlbi:BIT_WIDTH(14);	// if high, don't
							// broadcast tlbie
	unsigned	:BITS_WIDTH(13,0);
} mpc601_data_bp_mode_t;

/*
 * MPC601-specific:
 * Run Mode Interrupt Status Register (really SRR1)
 */
typedef struct {
	unsigned	:BITS_WIDTH(31,18);
	unsigned	trace:BIT_WIDTH(17);	// 1 => interrupt caused by
						// MSR(SE) trace mode
	unsigned	:BIT_WIDTH(16);
	MSR_BITS;
} rmisr_t;

/*
 * MPC601-specific:
 * Machine Check Interrupt Status Register (HID0)
 */
typedef struct {
	unsigned	e:BIT_WIDTH(31);	// master checkstop enable
	unsigned	s:BIT_WIDTH(30);	// micro-code self-test latch
	unsigned	m:BIT_WIDTH(29);	// checkstop with MSR(me)=0
	unsigned	td:BIT_WIDTH(28);	// multi-side hit in tlb
	unsigned	cd:BIT_WIDTH(27);	// multi-side hit in cache dir
	unsigned	sh:BIT_WIDTH(26);	// sequencer hang
	unsigned	dt:BIT_WIDTH(25);	// dispatch timeout
	unsigned	ba:BIT_WIDTH(24);	// bus address parity error
	unsigned	bd:BIT_WIDTH(23);	// bus data parity error
	unsigned	cp:BIT_WIDTH(22);	// cache parity error
	unsigned	iu:BIT_WIDTH(21);	// invalid micro-code instr
	unsigned	pp:BIT_WIDTH(20);	// pio bus protocol error
	unsigned	:BITS_WIDTH(19,17);	// reserved
	unsigned	es:BIT_WIDTH(16);	// enable ucode selftest ckstop
	unsigned	em:BIT_WIDTH(15);	// enable machine check ckstop
	unsigned	etd:BIT_WIDTH(14);	// enable tlb ckstop
	unsigned	ecd:BIT_WIDTH(13);	// enable cache dir ckstop
	unsigned	esh:BIT_WIDTH(12);	// enable sequencer hang ckstop
	unsigned	edt:BIT_WIDTH(11);	// enable disp timeout ckstop
	unsigned	eba:BIT_WIDTH(10);	// enable bus addr parity ckstop
	unsigned	ebd:BIT_WIDTH(9);	// enable bus data parity ckstop
	unsigned	ecp:BIT_WIDTH(8);	// enable cache parity ckstop
	unsigned	eiu:BIT_WIDTH(7);	// enable inval ucode ins ckstop
	unsigned	epp:BIT_WIDTH(6);	// enable pio bus prot ckstop
	unsigned	ddrip:BIT_WIDTH(5);	// disable dynamic reload of
						// alternate sector for instr
						// prefecth (>= DD2.0)
	unsigned	ddrls:BIT_WIDTH(4);	// disable dynamic reload of
						// alternate sector for
						// load/store ops (>= DD2.0)
	unsigned	:BIT_WIDTH(3);		// reserved
	unsigned	dpc:BIT_WIDTH(2);	// disable precharge for ARTRY
						// and SHARED signals (>= DD2.0)
	unsigned	emc:BIT_WIDTH(1);	// error in main cache
	unsigned	ehp:BIT_WIDTH(0);	// enable high pri write queue
						// for push data (>= DD2.0)
} mcisr_t;

#endif	_ARCH_PPC_MPC601_REGS_H_
