/* Exported API for standalone library */
#import <mach-o/loader.h>
#import <mach/mach.h>
#import <stdarg.h>
#import <stddef.h>

#ifndef bcopy
#ifdef __SLICK__
extern char *bcopy(char *src, char *dst, int n);
#endif
#endif

extern void *bsearch(const void *key, const void *base, size_t nmemb, size_t size, int (*compar)(const void *, const void *));
#ifndef bzero
#ifdef __SLICK__
extern int bzero(char *b, int length);
#endif
#endif
extern void *memset(void *s, int c, size_t n);

/*
 * These are defined internally by GCC
 *
 * extern char *memcpy(void *dst, const void *src, int len);
 * extern size_t strlen(const char *s);
 */

extern int errno;
extern struct segment_command *
  getsegbynamefromheader(struct mach_header *mhp, char *segname);
extern int ptol(char *str);

/* setjmp/longjmp:
 * #include <setjmp.h>
 *
 * extern int setjmp(jmp_buf env);
 * extern void longjmp( jmp_buf env, int val);
 */

extern int slvprintf(char *buffer, int len, const char *fmt, va_list arg);
extern int sprintf(char *s, const char *format, ...);

extern char *strcat(char *s1, const char *s2);
extern int strcmp(const char *s1, const char *s2);
extern char *strcpy(char *s1, const char *s2);
char *strerror(int errnum);
extern int strncmp(const char *s1, const char *s2, size_t n);
extern char *strncpy(char *s1, const char *s2, size_t n);
extern long strtol(
    const char *nptr,
    char **endptr,
    register int base
);
extern unsigned long strtoul(
    const char *nptr,
    char **endptr,
    register int base
);

/* Mach */
extern port_t task_self_;
extern kern_return_t vm_allocate(
    vm_task_t target_task,
    vm_address_t *address,
    vm_size_t size,
    boolean_t anywhere
);
extern kern_return_t vm_deallocate(
    vm_task_t target_task,
    vm_address_t address,
    vm_size_t size
);
extern kern_return_t host_info(
    host_t host,
    int flavor,
    host_info_t host_info,
    unsigned int *host_info_count
);
extern vm_size_t vm_page_size;
extern host_t host_self(void);
extern int getpagesize(void);
extern char *mach_error_string(int errnum);

/* Malloc/Zalloc */
extern int malloc_init(char *start, int size, int nodes);
extern void *malloc(size_t size);
extern void free(void *start);
extern char * zalloc(int size);
extern int zfree(char *start);
extern int zinit(char *start, int size, int nodes);
extern void *realloc(void *ptr, size_t size);
#define ZALLOC_NODES	64	/* default number of nodes */
