#include <mach/machine.h>
#include <mach-o/reloc.h>
#include <mach-o/m88k/reloc.h>
#include <mach-o/ppc/reloc.h>
#include <mach-o/i860/reloc.h>
#include <mach-o/hppa/reloc.h>
#include <mach-o/sparc/reloc.h>
#include "stuff/bool.h"
#include "stuff/errors.h"
#include "stuff/reloc.h"

/*
 * reloc_pair_r_type() returns the PAIR constant for the specific cputype for
 * a paired relocation entry.
 */
__private_extern__
unsigned long
reloc_pair_r_type(
cpu_type_t cputype)
{
	switch(cputype){
	case CPU_TYPE_MC680x0:
	case CPU_TYPE_I386:
	    return(GENERIC_RELOC_PAIR);
	    break;
	case CPU_TYPE_MC88000:
	    return(M88K_RELOC_PAIR);
	    break;
	case CPU_TYPE_I860:
	    return(I860_RELOC_PAIR);
	    break;
	case CPU_TYPE_POWERPC:
	    return(PPC_RELOC_PAIR);
	    break;
	case CPU_TYPE_HPPA:
	    return(HPPA_RELOC_PAIR);
	    break;
	case CPU_TYPE_SPARC:
	    return(SPARC_RELOC_PAIR);
	    break;
	}
	fatal("internal error: reloc_pair_r_type() called with unknown "
	      "cputype (%u)", cputype);
	/* can't get here but to shut up the compiler warning ... */
	return(0);
}

/*
 * reloc_has_pair() returns TRUE if the specified r_type for the specified
 * cputype for has a paired relocation entry.
 */
__private_extern__
enum bool
reloc_has_pair(
cpu_type_t cputype,
unsigned long r_type)
{
	switch(cputype){
	case CPU_TYPE_MC680x0:
	case CPU_TYPE_I386:
	    if(r_type == GENERIC_RELOC_SECTDIFF)
		return(TRUE);
	    break;
	case CPU_TYPE_MC88000:
	    if(r_type == M88K_RELOC_HI16 ||
	       r_type == M88K_RELOC_LO16 ||
	       r_type == M88K_RELOC_SECTDIFF)
		return(TRUE);
	    break;
	case CPU_TYPE_I860:
	    if(r_type == I860_RELOC_HIGH ||
	       r_type == I860_RELOC_HIGHADJ ||
	       r_type == I860_RELOC_SECTDIFF)
		return(TRUE);
	    break;
	case CPU_TYPE_POWERPC:
	    if(r_type == PPC_RELOC_HI16 ||
	       r_type == PPC_RELOC_LO16 ||
	       r_type == PPC_RELOC_HA16 ||
	       r_type == PPC_RELOC_LO14 ||
	       r_type == PPC_RELOC_SECTDIFF ||
	       r_type == PPC_RELOC_HI16_SECTDIFF ||
	       r_type == PPC_RELOC_LO16_SECTDIFF ||
	       r_type == PPC_RELOC_HA16_SECTDIFF ||
	       r_type == PPC_RELOC_JBSR)
		return(TRUE);
	    break;
	case CPU_TYPE_HPPA:
	    if(r_type == HPPA_RELOC_HI21 ||
	       r_type == HPPA_RELOC_LO14 ||
	       r_type == HPPA_RELOC_BR17 ||
	       r_type == HPPA_RELOC_JBSR ||
	       r_type == HPPA_RELOC_SECTDIFF ||
	       r_type == HPPA_RELOC_HI21_SECTDIFF ||
	       r_type == HPPA_RELOC_LO14_SECTDIFF)
		return(TRUE);
	    break;
	case CPU_TYPE_SPARC:
	    if (r_type == SPARC_RELOC_HI22 ||
		r_type == SPARC_RELOC_LO10 ||
		r_type == SPARC_RELOC_HI22_SECTDIFF ||
		r_type == SPARC_RELOC_LO10_SECTDIFF ||
		r_type == SPARC_RELOC_SECTDIFF)
	      return(TRUE);
	    break;
	default:
	    fatal("internal error: reloc_has_pair() called with unknown "
		  "cputype (%u)", cputype);
	}
	return(FALSE);
}

/*
 * reloc_is_sectdiff() returns TRUE if the specified r_type for the specified
 * cputype is a section difference relocation type.
 */
__private_extern__
enum bool
reloc_is_sectdiff(
cpu_type_t cputype,
unsigned long r_type)
{
	switch(cputype){
	case CPU_TYPE_MC680x0:
	case CPU_TYPE_I386:
	    if(r_type == GENERIC_RELOC_SECTDIFF)
		return(TRUE);
	    break;
	case CPU_TYPE_MC88000:
	    if(r_type == M88K_RELOC_SECTDIFF)
		return(TRUE);
	    break;
	case CPU_TYPE_I860:
	    if(r_type == I860_RELOC_SECTDIFF)
		return(TRUE);
	    break;
	case CPU_TYPE_POWERPC:
	    if(r_type == PPC_RELOC_SECTDIFF ||
	       r_type == PPC_RELOC_HI16_SECTDIFF ||
	       r_type == PPC_RELOC_LO16_SECTDIFF ||
	       r_type == PPC_RELOC_HA16_SECTDIFF)
		return(TRUE);
	    break;
	case CPU_TYPE_HPPA:
	    if(r_type == HPPA_RELOC_SECTDIFF ||
	       r_type == HPPA_RELOC_HI21_SECTDIFF ||
	       r_type == HPPA_RELOC_LO14_SECTDIFF)
		return(TRUE);
	    break;
	case CPU_TYPE_SPARC:
	    if(r_type == SPARC_RELOC_SECTDIFF ||
	       r_type == SPARC_RELOC_HI22_SECTDIFF ||
	       r_type == SPARC_RELOC_LO10_SECTDIFF)
		return(TRUE);
	    break;
	default:
	    fatal("internal error: reloc_is_sectdiff() called with unknown "
		  "cputype (%u)", cputype);
	}
	return(FALSE);
}





