#include <stdlib.h>
#include <string.h>

#include "stuff/bool.h"
#include "stuff/allocate.h"
#include "stuff/errors.h"

/*
 * get_version_number() converts an ascii version number string of the form:
 *	X[.Y[.Z]]
 * to an unsigned long with the value (X << 16) | (Y << 8) | Z and does
 * all the needed range checks.  The value is indirectly returned through value
 * and flag and argument are used for error messages.  It TRUE if there were
 * no errors FALSE otherwise.
 */
enum bool
get_version_number(
char *flag,
char *argument,
unsigned long *value)
{
    char *p, *x, *y, *z, *dot, *endp;
    unsigned long X, Y, Z;

	*value = 0;
	p = allocate(strlen(argument) + 1);
	strcpy(p, argument);

	y = NULL;
	z = NULL;

	x = p;
	dot = strchr(x, '.');
	if(dot != NULL && dot[1] != '\0'){
	    *dot = '\0';
	    y = dot + 1;
	    dot = strchr(y, '.');
	    if(dot != NULL && dot[1] != '\0'){
		*dot = '\0';
		z = dot + 1;
		dot = strchr(z, '.');
		if(dot != NULL){
		    *dot = '\0';
		}
	    }
	}

	Y = 0;
	Z = 0;

	X = strtoul(x, &endp, 10);
	if(*endp != '\0'){
	    error("first field (%s) in argument for: %s %s not a proper "
		  "unsigned number", x, flag, argument);
	    goto fail;
	}
	if(X > 0xffff){
	    error("first field (%s) in argument for: %s %s too large (maximum "
		  "%d)", x, flag, argument, 0xffff);
	    goto fail;
	}
	if(y != NULL){
	    Y = strtoul(y, &endp, 10);
	    if(*endp != '\0'){
		error("second field (%s) in argument for: %s %s not a proper "
		      "unsigned number", y, flag, argument);
		goto fail;
	    }
	    if(Y > 0xff){
		error("second field (%s) in argument for: %s %s too large "
		      "(maximum %d)", y, flag, argument, 0xff);
		goto fail;
	    }
	    if(z != NULL){
		Z = strtoul(z, &endp, 10);
		if(*endp != '\0'){
		    error("third field (%s) in argument for: %s %s not a "
			  "proper unsigned number", z, flag, argument);
		    goto fail;
		}
		if(Z > 0xff){
		    error("third field (%s) in argument for: %s %s too large "
			  "(maximum %d)", z, flag, argument, 0xff);
		    goto fail;
		}
	    }
	}
	*value = (X << 16) | (Y << 8) | Z;
	free(p);
	return(TRUE);

fail:
	free(p);
	return(FALSE);
}
