#import "AATApplication.h"
#import "AATTileView.h"
#import "TokenWindow.h"

@implementation AATApplication

- init
{
    int globalWindow;
    int status;

    if ([super init] == nil)
        return nil;

    tileWindow = [[NSWindow alloc] initWithContentRect:NSMakeRect (0, 0, 64, 64)
                                   styleMask:NSBorderlessWindowMask
                                   backing:NSBackingStoreBuffered
                                   defer:NO];

    tileView = [[AATTileView alloc] initWithFrame:NSMakeRect (0, 0, 64, 64)];
    [tileWindow setContentView:tileView];
    //[tileWindow orderFront:self];

    customTileView = nil;

    globalWindow = -1;
    NSConvertWindowNumberToGlobal ([tileWindow windowNumber], &globalWindow);
    //NSLog (@"global window number: %d", globalWindow);

    status = safeSetTokenWindow (globalWindow);
    if (status == -1)
        NSLog (@"Unable to set token window.");

    return self;
}

//----------------------------------------------------------------------

- (void) dealloc
{
    [tileView release];
    [customTileView release];
    [tileWindow release];

    [super dealloc];
}

//----------------------------------------------------------------------

- (NSWindow *) applicationTileWindow
{
    return tileWindow;
}

//----------------------------------------------------------------------

- (void) setApplicationIconImage:(NSImage *)newImage
{
    [super setApplicationIconImage:newImage];
    if (customTileView == nil)
    {
        [tileView setImage:newImage];
    }
}

//----------------------------------------------------------------------

- (AATTileView *) tileView
{
    return tileView;
}

//----------------------------------------------------------------------

- (NSView *) customTileView
{
    return customTileView;
}

//----------------------------------------------------------------------

- (void) setCustomTileView:(NSView *)newCustomTileView
{
    if (newCustomTileView == customTileView)
        return;

    [customTileView removeFromSuperview];
    [customTileView release];
    customTileView = [newCustomTileView retain];
    [tileView setImage:nil];
    [tileView addSubview:customTileView];
}

@end
