#import "TokenWindow.h"

#import <AppKit/psopsNeXT.h>
#import "TokenWindowWraps.h"

int safeSetTokenWindow (int tokenWindowNumber)
{
    int status = 0;

    if (tokenWindowNumber < 0)
        return -1;

    NS_DURING
        {
            PSWSetTokenWindow (tokenWindowNumber);
        }
    NS_HANDLER
        {
            if ([localException name] == DPSPostscriptErrorException)
            {
                status = -1;
            }
            else
            {
                [localException raise];
            }
        }
    NS_ENDHANDLER;

    return status;
}

//----------------------------------------------------------------------

int safePlaceTokenWindow (int tokenWindowNumber)
{
    int status = 0;

    if (tokenWindowNumber < 0)
        return -1;

    NS_DURING
        {
            PSWPlaceTokenWindow (tokenWindowNumber);
        }
    NS_HANDLER
        {
            if ([localException name] == DPSPostscriptErrorException)
            {
                status = -1;
            }
            else
            {
                [localException raise];
            }
        }
    NS_ENDHANDLER;

    return status;
}
