/*
 * Name: mtab_lock.c
 * Description: Locking of mtab files
 * Author: Christian Starkjohann <cs@hal.kph.tuwien.ac.at>
 * Date: 1997-04-30
 * Copyright: GNU-GPL
 * Tabsize: 4
 */

#include <libc.h>
#include <errno.h>
#include <mntent.h>
#include "my_defines.h"

extern int	errno;

#define	MOUNTED_LOCK	(MOUNTED ".lock")

static int	lock = -1;

int		lock_mtab(void)
{
int		i;

	if(lock < 0){
		i = 0;
		while((lock = open(MOUNTED_LOCK, O_WRONLY|O_CREAT|O_EXCL, 0)) < 0){
			if(errno != EEXIST){
				return 0;
			}
			usleep(20000);	/* sleep for 100ms */
			if(i++ > 150)
				return 1;	/* wait for a maximum of about 3s */
		}
    }
	return 1;
}

void	unlock_mtab(void)
{
	if(lock >= -1){
		close(lock);
	}
	unlink(MOUNTED_LOCK);
}
