/*
 * Name: segment.h
 * Description: asm/segment.h from Linux, but get_fs() get_ds() and set_fs()
 *     replaced with dummy functions.
 * Modified: Christian Starkjohann <cs@hal.kph.tuwien.ac.at>
 * Date: 1996-11-14
 * Copyright: GNU-GPL
 * Tabsize: 4
 */

#ifndef _ASM_SEGMENT_H
#define _ASM_SEGMENT_H

#define KERNEL_CS	0x10
#define KERNEL_DS	0x18

#define USER_CS		0x23
#define USER_DS		0x2B

#ifndef __ASSEMBLY__

/*
 * Uh, these should become the main single-value transfer routines..
 * They automatically use the right size if we just have the right
 * pointer type..
 */
#define put_user(x,ptr) __put_user((unsigned long)(x),(ptr),sizeof(*(ptr)))
#define get_user(ptr) ((__typeof__(*(ptr)))__get_user((ptr),sizeof(*(ptr))))

/*
 * This is a silly but good way to make sure that
 * the __put_user function is indeed always optimized,
 * and that we use the correct sizes..
 */
extern int bad_user_access_length(void);

/*
 * dummy pointer type structure.. gcc won't try to do something strange
 * this way..
 */
struct __segment_dummy { unsigned long a[100]; };
#define __sd(x) ((struct __segment_dummy *) (x))
#define __const_sd(x) ((const struct __segment_dummy *) (x))


static inline void __put_user(unsigned long x, void * y, int size)
{
	switch (size) {
		case 1:
			*(char *)y = (char)x;
			break;
		case 2:
			*(short *)y = (short)x;
			break;
		case 4:
			*(long *)y = (long)x;
			break;
		default:
			bad_user_access_length();
	}
}

static inline unsigned long __get_user(const void * y, int size)
{
	switch (size) {
		case 1:
			return *(unsigned char *)y;
		case 2:
			return *(unsigned short *)y;
		case 4:
			return *(unsigned long *)y;
		default:
			return bad_user_access_length();
	}
}


#define memcpy_fromfs(to, from, n)	memcpy(to, from, n)

#define memcpy_tofs(to, from, n)	memcpy(to, from, n)

/*
 * These are deprecated..
 *
 * Use "put_user()" and "get_user()" with the proper pointer types instead.
 */

#define get_fs_byte(addr) __get_user((const unsigned char *)(addr),1)
#define get_fs_word(addr) __get_user((const unsigned short *)(addr),2)
#define get_fs_long(addr) __get_user((const unsigned int *)(addr),4)

#define put_fs_byte(x,addr) __put_user((x),(unsigned char *)(addr),1)
#define put_fs_word(x,addr) __put_user((x),(unsigned short *)(addr),2)
#define put_fs_long(x,addr) __put_user((x),(unsigned int *)(addr),4)

#ifdef WE_REALLY_WANT_TO_USE_A_BROKEN_INTERFACE

static inline unsigned short get_user_word(const short *addr)
{
	return __get_user(addr, 2);
}

static inline unsigned char get_user_byte(const char * addr)
{
	return __get_user(addr,1);
}

static inline unsigned long get_user_long(const int *addr)
{
	return __get_user(addr, 4);
}

static inline void put_user_byte(char val,char *addr)
{
	__put_user(val, addr, 1);
}

static inline void put_user_word(short val,short * addr)
{
	__put_user(val, addr, 2);
}

static inline void put_user_long(unsigned long val,int * addr)
{
	__put_user(val, addr, 4);
}

#endif

/*
 * Someone who knows GNU asm better than I should double check the following.
 * It seems to work, but I don't know if I'm doing something subtly wrong.
 * --- TYT, 11/24/91
 * [ nothing wrong here, Linus: I just changed the ax to be any reg ]
 */

extern int	printf(const char *fmt, ...);

static inline unsigned long get_fs(void)
{
/*	printf("get_fs()\n"); */
	return KERNEL_DS;
}

static inline unsigned long get_ds(void)
{
/*	printf("get_ds()\n"); */
	return KERNEL_DS;
}

static inline void set_fs(unsigned long val)
{
	printf("*** set_fs()\n");
	abort();
}

#endif /* __ASSEMBLY__ */

#endif /* _ASM_SEGMENT_H */
