
#import <AppKit/NSWindowController.h>

@class NSText, NSTextField, NSButton;

@interface FindPanelController : NSWindowController
{
    IBOutlet NSTextField *stringField;
    IBOutlet NSTextField *statusField;
    IBOutlet NSButton    *nextButton;
    IBOutlet NSButton    *previousButton;
    IBOutlet NSButton    *ignoreCaseButton;
}

+ (id)sharedInstance;

- (IBAction)findNext:(id)sender;
- (IBAction)findPrevious:(id)sender;
- (IBAction)jumpToSelection:(id)sender;
- (IBAction)enterSelection:(id)sender;

- (NSText *)targetText;

- (NSString *)searchString;
- (NSString *)stringFromTargetText;
- (NSString *)stringFromFindPasteboard;
- (void)saveStringToFindPasteboard:(NSString *)aString;


@end
