
#import "ManDocument.h"
#import <Foundation/NSString.h>
#import <Foundation/NSTask.h>
#import <Foundation/NSUserDefaults.h>
#import <AppKit/NSButton.h>
#import <AppKit/NSButtonCell.h>
#import <AppKit/NSTextView.h>
#import <AppKit/NSTextStorage.h>
#import <AppKit/NSTextField.h>
#import <AppKit/NSPrintOperation.h>
#import <AppKit/NSPrintInfo.h>
#import "ManDocumentController.h"
#import "FindPanelController.h"

/*
 * The FOUNDATION_STATIC_INLINE #define appeared in Rhapsody, so if it's
 * not there we're on OPENSTEP.
 */
#ifndef FOUNDATION_STATIC_INLINE
#define OPENSTEP_ONLY
#endif

#ifdef OPENSTEP_ONLY
#define MAN_BINARY     @"/usr/ucb/man"
#define MANPATH_FORMAT @" -M '%@'"
#else
#define MAN_BINARY     @"/usr/bin/man"
#define MANPATH_FORMAT @" -m '%@'"
#endif

@implementation ManDocument

- initWithName:(NSString *)name
	section:(NSString *)section
	manPath:(NSString *)manPath
	title:(NSString *)title
{
    NSMutableString *command = [NSMutableString stringWithString:MAN_BINARY];

	[self setFileType:@"man"];
	[self setShortTitle:title];

	if (manPath && [manPath length] > 0)
        [command appendFormat:MANPATH_FORMAT, manPath];

	if (section && [section length] > 0)
		[command appendFormat:@" %@", [section lowercaseString]];

	[command appendFormat:@" %@", name];

	[self loadCommand:command];

	return self;
}

- (NSString *)windowNibName
{
    return @"ManPage";
}

/*
 * Standard NSDocument method.  We only want to override if we aren't
 * representing an actual file.
 */
- (NSString *)displayName
{
    return ([self fileName] != nil)? [super displayName] : [self shortTitle];
}

- (NSString *)shortTitle
{
    return shortTitle;
}

- (void)setShortTitle:(NSString *)aString
{
    [shortTitle autorelease];
	shortTitle = [aString retain];
}

- (NSText *)textView
{
    return textView;
}

- (NSString *)filterCommand
{
	NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
	NSString *command = [[NSBundle mainBundle] pathForResource:@"cat2rtf" ofType:nil];

	if ([defaults boolForKey:@"UseItalics"])
		command = [command stringByAppendingString:@" -i"];
	if (![defaults boolForKey:@"UseBold"])
		command = [command stringByAppendingString:@" -g"];

	return command;
}

- (void)showData
{
    if (rtfData && textView)
	{
		NSRange fullRange = NSMakeRange(0, [[textView textStorage] length]);
        [textView replaceCharactersInRange:fullRange withRTF:rtfData];
		// no need to keep around rtf data
		[rtfData release];
		rtfData = nil;
    }
}

- (void)loadCommand:(NSString *)command
{
	NSString *fullCommand = [NSString stringWithFormat:@"%@ | %@", command, [self filterCommand]];
    NSPipe *pipe = [[NSPipe alloc] init];
	NSTask *task = [[NSTask alloc] init];

    [task setLaunchPath:@"/bin/sh"];
    [task setArguments:[NSArray arrayWithObjects:@"-c", fullCommand, nil]];
    [task setStandardOutput:pipe];
    [task launch];

	[rtfData release];
    rtfData = [[[pipe fileHandleForReading] readDataToEndOfFile] retain];
    [task waitUntilExit];
	[pipe release];
	[task release];

	[self showData];
}

- (void)loadManFile:(NSString *)filename
{
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
	NSString *nroffFormat = [defaults stringForKey:@"NroffCommand"];
    NSString *nroffCommand;

    nroffCommand = [NSString stringWithFormat:nroffFormat, filename];
	[self loadCommand:nroffCommand];
}

- (void)loadCatFile:(NSString *)filename
{
	[self loadCommand:[NSString stringWithFormat:@"/bin/cat '%@'", filename]];
}

- (BOOL)readFromFile:(NSString *)fileName ofType:(NSString *)type
{
    if ([type isEqual:@"man"])
		[self loadManFile:fileName];
	else if ([type isEqual:@"cat"])
		[self loadCatFile:fileName];
	else return NO;

	[self setShortTitle:[[fileName lastPathComponent] stringByDeletingPathExtension]];

	return rtfData != nil;
}

- (void)windowControllerDidLoadNib:(NSWindowController *)windowController
{
	[super windowControllerDidLoadNib:windowController];

    [findSelectionButton setToolTip:@"Find selection"];
    [openSelectionButton setToolTip:@"Open selection"];
#ifndef WIN32
    [[findSelectionButton cell] setGradientType:NSGradientConcaveStrong];
    [[openSelectionButton cell] setGradientType:NSGradientConcaveStrong];
#endif

	if ([self shortTitle])
	    [titleStringField setStringValue:[self shortTitle]];
	[self showData];
}

- (IBAction)openSelection:(id)sender
{
	NSRange selectedRange = [textView selectedRange];

	if (selectedRange.length > 0)
    {
		NSString *selectedString = [[textView string] substringWithRange:selectedRange];
	    [[ManDocumentController sharedDocumentController] openString:selectedString];
	}
    [[textView window] makeFirstResponder:[self textView]];
}

- (IBAction)findNext:(id)sender        { [[FindPanelController sharedInstance] findNext:sender]; }
- (IBAction)findPrevious:(id)sender    { [[FindPanelController sharedInstance] findPrevious:sender]; }
- (IBAction)enterSelection:(id)sender  { [[FindPanelController sharedInstance] enterSelection:sender]; }
- (IBAction)jumpToSelection:(id)sender { [[FindPanelController sharedInstance] jumpToSelection:sender]; }

- (IBAction)searchForSelection:(id)sender
{
    [self enterSelection:sender];
    [self findNext:sender];
    [[textView window] makeFirstResponder:textView];
}

// always use the shared printinfo
- (BOOL)shouldChangePrintInfo:(NSPrintInfo *)printInfo
{
    return NO;
}

- (void)printShowingPrintPanel:(BOOL)showPanel
{
    NSPrintOperation *operation = [NSPrintOperation printOperationWithView:[self textView]];
    NSPrintInfo      *printInfo = [operation printInfo];

    [printInfo setVerticallyCentered:NO];
    [printInfo setHorizontallyCentered:YES];
    [printInfo setHorizontalPagination:NSFitPagination];
    [operation setShowPanels:showPanel];

    [operation runOperation];
}

- (BOOL)validateMenuItem:(NSMenuItem *)item
{
    if (![[FindPanelController sharedInstance] validateMenuItem:item]) return NO;
    return [super validateMenuItem:item];
}

@end
