
#import "NSData+Utils.h"
#import <libc.h>
#import <ctype.h>

@implementation NSData (Utils)

/*
 * Checks the data to see if it looks like the start of an nroff file.
 * Derived from logic in FreeBSD's file(1) command.
 */
- (BOOL)isNroffData
{
	const char *bytes = [self bytes];
	const char *ptr = bytes;
	
	while (isspace(*ptr)) ptr++;
	
	/* If not at the beginning of a line, bail. */
	if (!(ptr == bytes || *(ptr-1) == '\n' || *(ptr-1) == '\r')) return NO;


#define MATCH(str) (strncmp(ptr, str, strlen(str)) == 0)

	/* Try for some common prefixes: .\", '\", '.\", \", and .\<sp> */
	if (MATCH(".\\\""))  return YES;
	if (MATCH("'\\\""))  return YES;
	if (MATCH("'.\\\"")) return YES;
	if (MATCH("\\\""))   return YES;
	if (MATCH(".\\ "))   return YES;
	
    /*
     * Now check for .[letter][letter], and .\" again.  In either case,
     * allow spaces after the '.'
     */
	if (*ptr == '.')
	{
		/* skip over '.' and whitespace */
		ptr++;
		while (isspace(*ptr)) ptr++;

		if (isalnum(ptr[0]) && isalnum(ptr[1])) return YES;
		if (ptr[0] == '\\'  && ptr[1] == '"')   return YES;
	}
	
	return NO;
}

@end

