/* MeltingView.m created by epeyton on Mon 26-Apr-1999 */

#import "MeltingView.h"

#define	RAND_MAX	0x7fffffff

float randBetweenForMelting(float a, float b)
{
    float	val, scale, t;

    if (a > b) {
        t = a; a = b; b = t;
    }

    scale = (b - a);
    val = scale * ((float) random() / (float) RAND_MAX);
    return (a + val);
}


@implementation MeltingView


- (BOOL)useBufferedWindow
{
    return YES;
}

- (id)initWithFrame:(NSRect)frameRect
{    
    if (![super initWithFrame:frameRect]) return nil;

    yDict = [[NSMutableDictionary alloc] init];
    zDict = [[NSMutableDictionary alloc] init];
    [self allocateGState];
    srandom(time(0));

    return self;
}

- (NSView *)inspector:sender
{
    if (!sharedInspectorPanel) {
        [NSBundle loadNibNamed:@"MeltingScreen.nib" owner:self];
    }

    return sharedInspectorPanel;
}


//
// The Graphics Code
//

- (void)drawRect:(NSRect)rects
{
}

- (void)oneStep
{
    int i = 0;
    // if five minutes have gone by, rearrange the melting view.
    if ( (!timer) || ([timer compare:[NSDate date]] == NSOrderedAscending) ) {
        //[[NSColor blackColor] set];
        //NSRectFill([self bounds]);
        [yDict release];
        [zDict release];
        yDict = [[NSMutableDictionary alloc] init];
        zDict = [[NSMutableDictionary alloc] init];

        [buffer compositeToPoint:NSMakePoint(0,0) operation:NSCompositeCopy];
        [timer release];
        timer = [[NSDate dateWithTimeIntervalSinceNow:(60.0 * 5)] retain];
    }

    //melt a few rows on the screen
    while (i < 50) {
        int x = floor(randBetweenForMelting(0.0,[self bounds].size.width));
        int y = floor(randBetweenForMelting(0.0,[self bounds].size.height));
        int z = floor(randBetweenForMelting (1.0, 3.0));  // amount to move

        if ([yDict objectForKey:[NSNumber numberWithInt:x]]) { // get the y
        	y  = [[yDict objectForKey:[NSNumber numberWithInt:x]] intValue];
        	z = z + [[zDict objectForKey:[NSNumber numberWithInt:x]] intValue];
       	}

        {
            NSPoint point = NSMakePoint(x, y - z);
            NSPoint point2 = NSMakePoint(x - 1, y - z - 1);
            NSPoint point3 = NSMakePoint(x + 1, y - z - 1);
            NSRect rect = NSMakeRect(x,y,1,[self bounds].size.height - y);
            NSRect rect2 = NSMakeRect(x - 1 ,y - 2,1,[self bounds].size.height - y - 2);
            NSRect rect3 = NSMakeRect(x + 1,y - 2,1,[self bounds].size.height - y - 2);

            [buffer compositeToPoint:point fromRect:rect operation:NSCompositeSourceOver];
            [buffer compositeToPoint:point2 fromRect:rect2 operation:NSCompositeSourceOver];
            [buffer compositeToPoint:point3 fromRect:rect3 operation:NSCompositeSourceOver];
        }

        [yDict setObject:[NSNumber numberWithInt:y] forKey:[NSNumber numberWithInt:x]];
        [yDict setObject:[NSNumber numberWithInt:y - 2] forKey:[NSNumber numberWithInt:x + 1]];
        [yDict setObject:[NSNumber numberWithInt:y - 2] forKey:[NSNumber numberWithInt:x - 1]];

        [zDict setObject:[NSNumber numberWithInt:z] forKey:[NSNumber numberWithInt:x]];
        [zDict setObject:[NSNumber numberWithInt:z] forKey:[NSNumber numberWithInt:x + 1]];
        [zDict setObject:[NSNumber numberWithInt:z] forKey:[NSNumber numberWithInt:x - 1]];
        
        i++;
    }
    
    return;
}

- (void)willEnterScreenSaverMode
{
    [yDict release];
    [zDict release];
    yDict = [[NSMutableDictionary alloc] init];
    zDict = [[NSMutableDictionary alloc] init];
    [self loadBuffer];
}

- (void)willExitScreenSaverMode
{
    if (buffer) {
        [buffer release];
        buffer = nil;
    }
    [timer release];
    timer = nil;
}

// this will probably break in Mac OS X.
- (void)loadBuffer
{
   id snapShot;
   NSSize screen;
   NSRect imageRect = NSMakeRect(0,0,0,0);

   screen = [self bounds].size;
   imageRect.size = screen;
   snapShot = [[NSWindow alloc] initWithContentRect:imageRect
                                          styleMask:NSBorderlessWindowMask
                                            backing:NSBackingStoreNonretained
                                              defer:NO];
   PSsetwindowlevel(NSPopUpMenuWindowLevel,[snapShot windowNumber]);
   PSsetautofill(NO,[snapShot windowNumber]);
   [snapShot orderFront:self];
   if (!buffer) {
           buffer = [[NSImage alloc] initWithSize:screen];
   }
   [buffer lockFocus];
   PScomposite(0.0,0.0,screen.width,screen.height,[snapShot gState],
               0.0,0.0,NSCompositeCopy);
   [buffer unlockFocus];
   [snapShot release];
}


@end
