// TEGotoPanelController.h
// TextExtras - Yellow Box
//
// Copyright 1996-1999, Mike Ferris.
// All rights reserved.

// This class controls a goto panel that can select by number either character or line ranges.  You can type a character or line range into a text field and select that range in the active text document of many apps.  It can also watch as you change the selection directly in the text document and keep its display in synch with the actual selection.
// The goto panel uses the GotoPanelAutoupdates and GotoPanelShowsLineRanges defaults to get the initial state of the autoupdate checkbox and the character vs. line range radio buttons.  Valid values are YES and NO.  By default autoupdating is NO and shows line ranges is YES.

#import <AppKit/AppKit.h>

@interface TEGotoPanelController : NSWindowController {
    IBOutlet NSTextField *textField;
    IBOutlet NSButton *gotoButton;
    IBOutlet NSMatrix *radioButtons;
    IBOutlet NSButton *autoupdateCheckbox;

    NSTextView *autoupdateTextView;
    BOOL autoupdateFlag;
}

+ (id)sharedGotoPanelController;

- (IBAction)autoupdateAction:(id)sender;
- (IBAction)gotoAction:(id)sender;
- (IBAction)textFieldAction:(id)sender;

- (void)updateFieldFromTextView:(NSTextView *)textView;

- (void)selectRangeText;

@end
