// TEPipeCommand.h
// TextExtras - Yellow Box
//
// Copyright 1996-1999, Mike Ferris.
// All rights reserved.

#import <AppKit/AppKit.h>

// MF: The values in following two enumerations match the row numbers of the radio buttons for each option in the TEPipePanelController UI.
// Where to get stdin.
typedef enum {
    NoInput = 0,
    SelectionInput = 1,
    CompleteTextInput = 2
} TEStandardInputSource;

// Where to put stdout.
typedef enum {
    OutputDiscarded = 0,
    OutputReplacesSelection = 1,
    OutputReplacesCompleteText = 2,
    OutputToSeparateWindow = 3,
} TEStandardOutputDestination;


@interface TEPipeCommand : NSObject <NSCopying> {
    @public
    NSString *commandString;
    TEStandardInputSource inputSource;
    TEStandardOutputDestination outputDestination;
    NSString *keyEquivalent;
    
    @private
    NSData *_stdoutData;
}

- (id)initWithCommandString:(NSString *)command standardInputSource:(TEStandardInputSource)inSrc standardOutputDestination:(TEStandardOutputDestination)outDest keyEquivalent:(NSString *)keyEquiv;
- (id)initWithDictionary:(NSDictionary *)dict;

- (NSDictionary *)dictionaryRepresentation;

- (NSString *)runWithInputString:(NSString *)input;
- (BOOL)runWithTextView:(NSTextView *)textView;

@end
