/*
    File:       QMacDefines.h

    Contains:   Some common Mac OS defines required by the other modules.

    Written by: Quinn "The Eskimo!"

    Created:    Wed 21-May-1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

// OpenStep representations of the well-defined integer types.  At this point I'm
// assume that OpenStep defines that long must be 32 bits, short 16 bits and char
// 8 bits.

// Signed

typedef unsigned long  UInt32;
typedef unsigned short UInt16;
typedef unsigned char  UInt8;

// Unsigned

typedef signed long  SInt32;
typedef signed short SInt16;
typedef signed char  SInt8;

// Mac OS strings consist of a length byte followed by that
// number of characters.  They are defined as unsigned characters
// to promote automatic type checking.

typedef UInt8 *StringPtr;
