/*
    File:       QResourceTypesEnumerator.h

    Contains:   An enumerator that returns all the resources types
                in a resource file.

    Written by: Quinn "The Eskimo!"

    Created:    Mon 19-May-1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import <AppKit/AppKit.h>

@class QResourceFile, QResourceObject;

@interface QResourceTypesEnumerator : NSEnumerator
{
    QResourceFile *resFile;		// The resource file we're enumerating.
    long typeIndex;			// The index of the next entry in the resource type list.
    long numResourceTypes;		// The count of the number of resources types resFile.
}

- (id)initWithResourceFile:(QResourceFile*)aResFile;
    // Initialise a newly allocated object to enumerate the resources types
    // in the resource file denoted by resFile.

- (QResourceObject *)nextObject;
    // Returns the next resource type.  Note that we actually return a QResourceObject
    // rather than just the QResourceType because the class definition for NSEnumerator
    // requires that we return an object.  This special form of QResourceObject just
    // contains type information, as noted in "QResourceObject.h".

@end
