/*$Id: SenTestCase.h,v 1.2 1998/12/20 16:51:22 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#import <Foundation/NSObject.h>
#import "SenTest.h"

#define should(condition)
#define shouldnt(condition)
#define shouldBeEqual(left,right)
#define shouldRaise(expression)
#import "SenTestCase_Macros.h"

@class SenTestSuite;
@class SenTestCaseRun;

@interface SenTestCase : SenTest <NSCoding>
{
    @private
    NSInvocation *invocation;
    NSString *name;
    SenTestCaseRun *run;
    SEL failureAction;
}

- (Class) classForCoder;

+ (id) testCaseWithInvocation:(NSInvocation *) anInvocation;
- (id) initWithInvocation:(NSInvocation *) anInvocation;

+ (id) testCaseWithSelector:(SEL) aSelector;
- (id) initWithSelector:(SEL) aSelector;
- (SEL) selector;

- (void) continueAfterFailure;
- (void) raiseAfterFailure;

- (void) setUp;
- (void) tearDown;

- (void) failWithException:(NSException *) anException;
@end


@interface SenTestCase (Suite)
+ (id) defaultTestSuite;
@end

