/*$Id: SenTestRun.h,v 1.1 1998/12/20 16:51:44 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#import <Foundation/NSObject.h>
#import "SenTest.h"

@interface SenTestRun : NSObject <NSCoding>
{
    NSTimeInterval startDate;
    NSTimeInterval stopDate;
    SenTest * test;
}

+ (id) testRunWithTest:(SenTest *) aTest;
- (id) initWithTest:(SenTest *) aTest;

- (SenTest *) test;

- (void) start;
- (void) stop;

- (NSDate *) startDate;
- (NSDate *) stopDate;
- (NSTimeInterval) totalDuration;     // total elapsed time
- (NSTimeInterval) testDuration; // time spent in test cases

- (unsigned int) failureCount;
- (unsigned int) errorCount;

- (BOOL) hasSucceeded;
@end
