/*$Id: SenTestRun.m,v 1.1 1998/12/20 16:51:46 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#import "SenTestRun.h"
#import <SenFoundation/SenFoundation.h>

@implementation SenTestRun
+ (id) testRunWithTest:(SenTest *) aTest
{
    return [[[self alloc] initWithTest:aTest] autorelease];
}


- (id) initWithTest:(SenTest *) aTest
{
    self = [super init];
    RETAIN (test, aTest);
    return self;
}


- (void) dealloc
{
    RELEASE(test);
    [super dealloc];
}


- (id) initWithCoder:(NSCoder *) aCoder
{
    test = [[aCoder decodeObject] retain];
    [aCoder decodeValueOfObjCType:@encode(NSTimeInterval) at:&startDate];
    [aCoder decodeValueOfObjCType:@encode(NSTimeInterval) at:&stopDate];
    return self;
}


- (void) encodeWithCoder:(NSCoder *) aCoder
{
    [aCoder encodeObject:test];
    [aCoder encodeValueOfObjCType:@encode(NSTimeInterval) at:&startDate];
    [aCoder encodeValueOfObjCType:@encode(NSTimeInterval) at:&stopDate];
}


- (SenTest *) test
{
    return test;
}


- (NSTimeInterval) totalDuration
{
    return stopDate - startDate;
}


- (NSTimeInterval) testDuration
{
    return [self totalDuration];
}


- (NSDate *) startDate
{
    return [NSDate dateWithTimeIntervalSinceReferenceDate:startDate];
}


- (NSDate *) stopDate
{
    return [NSDate dateWithTimeIntervalSinceReferenceDate:stopDate];
}


- (void) start
{
    startDate = [NSDate timeIntervalSinceReferenceDate];
}


- (void) stop
{
    stopDate = [NSDate timeIntervalSinceReferenceDate];
}


- (unsigned int) failureCount
{
    return 0;
}


- (unsigned int) errorCount
{
    return 0;
}


- (BOOL) hasSucceeded
{
    return ([self failureCount] == 0) && ([self errorCount] == 0);
}



- (NSString *)description
{
    return [NSString stringWithFormat:@"Test:%@ started:%@ stopped:%@", [self test], [self startDate], [self stopDate]];
}
@end
