/*$Id: NSBundle_SenAdditions.m,v 1.2 1998/12/20 16:40:10 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#import "NSBundle_SenAdditions.h"

#define BUILD_NUMBER_KEY  @"SenBuildNumber"
#define VERSION_KEY       @"SenVersion"

#ifdef WIN32
#define EXECUTABLE_EXTENSION @".exe"
#else
#define EXECUTABLE_EXTENSION @""
#endif


@implementation NSBundle (SenAdditions)
- (NSString *) executablePath
{
    NSDictionary *dictionary = [self infoDictionary];
    if (dictionary != nil) {
        NSString *executableName = [dictionary objectForKey:@"NSExecutable"];
        if (executableName != nil) {
            NSString *path = [NSString stringWithFormat:@"%@/%@%@", [self bundlePath], executableName, EXECUTABLE_EXTENSION];
            return ([[NSFileManager defaultManager] fileExistsAtPath:path]) ? path : [NSString stringWithFormat:@"%@_debug%@", path, EXECUTABLE_EXTENSION];
        }
    }
    return nil;
}


- (NSString *) buildNumber
{
    return [[self infoDictionary] objectForKey:BUILD_NUMBER_KEY];
}


- (NSString *) version
{
    return [[self infoDictionary] objectForKey:VERSION_KEY];
}


- (NSString *) fullVersionString
{
    return [NSString stringWithFormat:@"%@ (build %@)", [self version], [self buildNumber]];
}

@end
