/*$Id: SenClassEnumerator.m,v 1.2 1998/12/20 16:40:28 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#import "SenClassEnumerator.h"

@implementation SenClassEnumerator

+ (NSEnumerator *) classEnumerator
{
    return [[[self alloc] init] autorelease];
}


- (id) init
{
    self = [super init];
    class_hash = objc_getClasses();
    state = NXInitHashState(class_hash);
    isAtEnd = NO;
    return self;
}


- (id) nextObject
{
    if (isAtEnd) {
        return nil;
    }
    else {
        Class class;
        isAtEnd = !NXNextHashState(class_hash, &state, (void **) &class);
        return isAtEnd ? nil : class;
    }
}
@end
