/*+++
 *  title:      MailMessageDeliveryProxy.m
 *  abstract:   Implementation of MailMessageDeliveryProxy class for mailapp-utilities.
 *  author:     Tom Hageman <tom@basil.icce.rug.nl>
 *  created:    October 1998
 *  modified:   
 *  copyleft:
 *
 *	Copyright (C) 1998  Tom R. Hageman, but otherwise perfect freeware.
 *
 *  description:
 *
 *      Private concrete MailProxy subclass.
 *	Implements communication with NSMessageDelivery, from
 *	Message.framework on Rhapsody.
 *
 *  BUGS:
 *	(On RDR2 at least)
 *	- case is not preserved in headers.
 *	- 'From ' and Return-Path: headers are mangled (SMTP at least):
 *	  the sender's name is *nil*.
 *---*/

static const char * const RCSid = ((void)&RCSid,
	"@(#)MailMessageDeliveryProxy.m,v 1.5 1998/12/02 00:27:52 tom Exp");
#define RCS_MailAppProxy_ID

#import "MailProxy.h"
#import "mailutil.h"
#import <stdlib.h>

#if NEXTSTEP || OPENSTEP
 #error <Message/NSMailDelivery> not supported on NEXTSTEP/OPENSTEP.
#endif


#import <Message/NSMailDelivery.h>


@interface MailMessageDeliveryProxy : MailProxy
{
}

@end // MailMessageDeliveryProxy


@implementation MailMessageDeliveryProxy

//+ (BOOL)canEditMessage  	{ return NO; }
+ (BOOL)canDeliverMessage	{ return YES; }
//+ (BOOL)canIncorporateNewMail	{ return NO; }
+ (BOOL)canSendBcc		{ return YES; }
+ (BOOL)canSendArbitraryHeaders	{ return YES; }


- (void)dealloc
{
   [super dealloc];
}


- (BOOL)connectToMailer
{
   return YES;
}


- (BOOL)sendMailBody:(id)body headers:(NSDictionary *)headers
{
   const char *deliveryMethod = NXGetDefaultValue(MAIL_APP, "DeliveryMethod");
   NSString *deliveryProtocol = (deliveryMethod == NULL ? nil :
				 strcasecmp(deliveryMethod, "SMTP") == 0 ?
				    NSSMTPDeliveryProtocol :
				 strcasecmp(deliveryMethod, "sendmail") == 0 ?
				    NSSendmailDeliveryProtocol :
				    nil);

   if ([headers objectForKey:@"From"] == nil)
   {
      // Add From: header to workaround the worst of the RDR2 bugs...
      NSString *sender = [NSString stringWithFormat:@"%@ <%@>",
			      NSFullUserName(), NSUserName()];

      headers = [NSMutableDictionary dictionaryWithDictionary:headers];
      [(NSMutableDictionary *)headers setObject:sender forKey:@"From"];
   }
   body = [self replacementObjectForBody:body];

   return [NSMailDelivery deliverMessage:body headers:headers
	   format:NSMIMEMailFormat protocol:deliveryProtocol];
}


- (id)replacementObjectForBody:(id)body
{
   if (body && ![body isKindOfClass:[NSAttributedString class]])
   {
      if ((body = [super replacementObjectForBody:body]) != nil)
      {
	 body = [[[NSAttributedString alloc] initWithString:body] autorelease];
      }
   }
   return body;
}

@end // MailMessageDeliveryProxy
