//-----------------------------------------------------------------------------
//
//	MailSpeaker
//
//	Inherits From:		Speaker
//
//	Declared In:		MailSpeaker.h
//
//	Disclaimer
//
//		You may freely copy, distribute and reuse this software and its
//		associated documentation. I disclaim any warranty of any kind, 
//		expressed or implied, as to its fitness for any particular use.
//
//-----------------------------------------------------------------------------
#import "MailSpeaker.h"
//#import <mach/mach.h>
//#import <mach/message.h>
//#import <servers/netname.h>


@implementation MailSpeaker

- (int)incorporateNewMail
{
   return [self selectorRPC:S_("incorporateNewMail") paramTypes:""];
}

- (int)deliver
{
   return [self selectorRPC:S_("deliver") paramTypes:""];
}

- (int)openSend
{
   return [self selectorRPC:S_("openSend") paramTypes:""];
}

- (int)setBody:(const char *)aString
{
   return [self selectorRPC:S_("setBody:") paramTypes:"c", aString];
}

- (int)setCc:(const char *)aString
{
   return [self selectorRPC:S_("setCc:") paramTypes:"c", aString];
}

- (int)setSubject:(const char *)aString
{
   return [self selectorRPC:S_("setSubject:") paramTypes:"c", aString];
}

- (int)setTo:(const char *)aString
{
   return [self selectorRPC:S_("setTo:") paramTypes:"c", aString];
}

- (int)deliver:(int)aWindow
{
   return [self selectorRPC:S_("deliver:") paramTypes:"i", aWindow];
}

- (int)openSend:(int *)aWindow
{
   return [self selectorRPC:S_("openSend:") paramTypes:"I", aWindow];
}

- (int)setBody:(const char *)aString inWindow:(int)aWindow
{
   return [self selectorRPC:S_("setBody:inWindow:") paramTypes:"ci", aString, aWindow];
}

- (int)setCc:(const char *)aString inWindow:(int)aWindow
{
   return [self selectorRPC:S_("setCc:inWindow:") paramTypes:"ci", aString, aWindow];
}

- (int)setSubject:(const char *)aString inWindow:(int)aWindow
{
   return [self selectorRPC:S_("setSubject:inWindow:") paramTypes:"ci", aString, aWindow];
}

- (int)setTo:(const char *)aString inWindow:(int)aWindow
{
   return [self selectorRPC:S_("setTo:inWindow:") paramTypes:"ci", aString, aWindow];
}

@end // MailSpeaker
