/* -*-C-*-
*******************************************************************************
*
* File:         listmail.m
* RCS:          /usr/local/sources/CVS/mailapp-utilities/listmail.m,v 1.16 1998/11/21 17:35:56 tom Exp
* Description:  List the contents of a Mail.app table_of_contents
* Author:       Carl Edman
* Created:      Fri Mar 12 18:21:23 1993
* Modified:     Thu Aug  6 15:30:37 1998 Tom Hageman <tom@basil.icce.rug.nl>
* Language:     Objective C
* Package:      mailapp-utilities
* Status:       Exp.
*
* (C) Copyright 1993, but otherwise this file is perfect freeware.
*
*******************************************************************************
*/

#import <libc.h>
#import <errno.h>
//#import <stdlib.h>
//#import <stdio.h>
//#import <string.h>
//#import <time.h>
//#import <regex.h>
//#import <sys/file.h>
//#import <sys/param.h>
//#import <sys/types.h>
//#import <sys/stat.h>
#import "compat.h"
#import "mailutil.h"
#define _MAILTOC_DEFINES 1
#import "mailtoc.h"
#import "optutil.h"

#define USAGE "\
Usage: %s [-v] [-t] [-a|-hdfnru] [-p prefix] [-w|-T sec] [-H|-V] mbox...\n"

#define HELP "\
 -v            talkative mode\n\
 -t            show number of messages instead of listing summaries\n\
 -a            show all messages (default unless any of the following)\n\
 -h              show mailbox header (default unless -a,-t,any of the following)\n\
 -d              show deleted messages\n\
 -f              show flagged messages\n\
 -n              show new messages\n\
 -r              show read messages (incl. flagged)\n\
 -u              show unread messages (incl. new)\n\
 -p prefix     prepend prefix to mbox, table_of_contents inside .mbox\n\
 -w            wait for mailbox locks\n\
 -T sec        timeout: give up after `sec' seconds if mailbox is locked\n\
 -V,--version  show version\n\
 -H,--help     this help\n\
"


int main(int ac,char *av[])
{
   int c,width;
   int verboseflg=0,nowaitflg=1,countonlyflg=0,lockedflg;
   int allflg = -1, headerflg = 0, unknownflg = 0;
   int readflg = 0, unreadflg = 0, newflg = 0, deletedflg = 0, flaggedflg = 0;
   FILE *tocf;
   char *p;
   struct table_of_contents_header *toch=0;
   struct message_index *mi=0;
   int status=EXIT_SUCCESS;
   char *mbox=MBOX_CONTENTS_FILE,*table_of_contents=MBOX_TOC_FILE;
   POOL_INIT

   set_progname(av[0]);

   for (;;)
   {
      switch ((c=getopt(ac,av,"vtp:wT:ahrundfUVH")))
      {
       case 'v':
	 verboseflg++;
	 continue;
       case 't':
	 countonlyflg++;
	 continue;
       case 'p':
	 mbox=malloc(strlen(optarg)+strlen(MBOX_CONTENTS_FILE)+1);
	 sprintf(mbox, "%s"MBOX_CONTENTS_FILE, optarg);
	 table_of_contents=malloc(strlen(optarg)+strlen(MBOX_TOC_FILE)+1);
	 sprintf(table_of_contents, "%s"MBOX_TOC_FILE, optarg);
	 continue;
       case 'w':
	 nowaitflg = 0;
	 continue;
       case 'T':
	 nowaitflg = -atoi(optarg);
	 if (nowaitflg >= 0) nowaitflg = !nowaitflg;
	 continue;
       case 'a':
	 allflg = 1;
	 continue;
       case 'h':
	 headerflg = 1;
	 if (allflg < 0) allflg = 0;
	 continue;
       case 'r':
	 readflg = 1;
	 if (allflg < 0) allflg = 0;
	 continue;
       case 'u':
	 unreadflg = 1;
	 if (allflg < 0) allflg = 0;
	 continue;
       case 'n':
	 newflg = 1;
	 if (allflg < 0) allflg = 0;
	 continue;
       case 'd':
	 deletedflg = 1;
	 if (allflg < 0) allflg = 0;
	 continue;
       case 'f':
	 flaggedflg = 1;
	 if (allflg < 0) allflg = 0;
	 continue;
       case 'U':
	 unknownflg = 1;
	 if (allflg < 0) allflg = 0;
	 continue;
       case 'V':
	 status=EXIT_VERSION;
	 break;
       case 'H':
	 status=EXIT_HELP;
	 break;
       case EOF:
	 status=check_arg_for_long_help_version(av[optind-1]);
	 break;
       case '?':
       default:
	 status=EXIT_USAGE;
      }
      break;
   }
   if (status==EXIT_SUCCESS && optind>=ac) status=EXIT_USAGE;
   handle_usage_help_version(status, USAGE, HELP);

   for(;optind<ac;optind++)
   {
      int readcnt = 0, unreadcnt = 0, newcnt = 0, deletedcnt = 0;
      int flaggedcnt = 0, unknowncnt = 0;
      int priority;
      time_t s,t;
      
      if (verboseflg) logprintf("Entering %s...",av[optind]);
      if (cd_mbox(av[optind],0)) goto next;
      lockedflg=lock_mbox(nowaitflg);

      if ((tocf=fopen(table_of_contents,"rb"))==NULL)
      {
         logprintf("%s: opening: %s",av[optind],strerror(errno));
         goto unlock;
      }

      toch=get_table_of_contents_header(tocf,0);
      if (!toch)
      {
         logprintf("%s: invalid table_of_contents",av[optind]);
         goto unlock;
      }

      if (countonlyflg && allflg < 0)
      {
         printf("%d\n",toch->num_msgs);
         goto unlock;
      }

      if (allflg < 0 || headerflg)
      {
	 printf("Table of contents (magic=%d):\n",toch->magic);
	 printf("Number of messages:%5d   Modification Time: %.24s",toch->num_msgs,
		ctime(&toch->mbox_time));
	 if (toch->mbox_time!=(s=mtime(mbox)))
	 {
	    printf("(!=%.24s; 0x%lx!=0x%lx)",ctime(&s), toch->mbox_time, s);
	 }
	 
	 printf("\nAt (%.2f,%.2f) %.2fx%.2f(%.2f)\n",toch->window.origin.x,
		toch->window.origin.y,toch->window.size.width,toch->window.size.height,
		toch->list);
      }

      for(c=toch->num_msgs,width=0;c>0;) { width++; c/=10; }

      for(c = 0;  c < toch->num_msgs;  c++, free(mi), mi = NULL)
      {
	 int y, m, d;

         if ((mi=get_message_index(tocf))==0)
	 {
            logprintf("%s: reading mbox entries: %s",av[optind],(errno?strerror(errno):"invalid"));
            goto unlock;
	 }
	 /* Filter/count messages according to type. */
	 if (!allflg || countonlyflg)
	 {
	    switch (mi->status)
	    {
	    case MT_STATUS_READ_1:
	    case MT_STATUS_READ_2:
	    case MT_STATUS_READ_3:
	       ++readcnt;
	       if (readflg) break;
	       continue;
	    case MT_STATUS_UNREAD_1:
	    case MT_STATUS_UNREAD_2:
	       ++unreadcnt;
	       if (unreadflg) break;
	       continue;
	    case MT_STATUS_NEW:
	       ++newcnt;
	       if (newflg || unreadflg) break;
	       continue;;
	    case MT_STATUS_FLAGGED:
	       ++flaggedcnt;
	       if (flaggedflg || readflg) break;
	       continue;
	    case MT_STATUS_DELETED_1:
	    case MT_STATUS_DELETED_2:
	       ++deletedcnt;
	       if (deletedflg) break;
	       continue;
	    default:
	       ++unknowncnt;
	       if (unknownflg) break;
	       continue;
	    }
	    if (countonlyflg) continue;
	 }
	 message_get_date(mi, &y, &m, &d);
         printf("%c%c%c%c%*d %d/%02d/%02d %5d/%7d %s:%s",mi->status,mi->msgtype,mi->encrypted,mi->sync,width,c+1,y,m,d,mi->mes_length,mi->mes_offset,message_from(mi),message_subject(mi));
         if ((p=message_reference(mi)) && *p)
	 {
            t=message_attachtime(mi);
            s=mtime(p);
	    printf(" (%s:%d@%.24s", p, message_attachsize(mi),ctime(&t));
            if (t!=s) printf(" != %.24s",ctime(&s));
            printf(")");
	 }

         if ((priority=message_priority(mi))>0)
	 {
            printf(" (pri=%d)",priority);
	 }

	 if (verboseflg > 1)
	 {
	    t = message_time(mi);
	    printf(" (date=%.24s)", ctime(&t));
	 }
         printf("\n");
      }

      if (countonlyflg)
      {
	 const char *fmt = (allflg || unknowncnt ||
			    (readflg + unreadflg + newflg + deletedflg +
			     flaggedflg + unknownflg) > 1) ? "%*d\t%s\n" : "%*d\n";

	 if (allflg || deletedflg)     printf(fmt, width, deletedcnt, "deleted");
	 if (allflg || readflg)	       printf(fmt, width, readcnt + flaggedcnt, (flaggedcnt ? "read + flagged" : "read"));
	 if (allflg || flaggedflg)     printf(fmt, width, flaggedcnt, "flagged");
	 if (allflg || unreadflg)      printf(fmt, width, unreadcnt + newcnt, (newcnt ? "unread + new" : "unread"));
	 if (allflg || newflg)	       printf(fmt, width, newcnt, "new");
	 if (unknowncnt || unknownflg) printf(fmt, width, unknowncnt, "UNKNOWN");
	 if (allflg)		       printf(fmt, width, toch->num_msgs, "TOTAL");
      }

    unlock:
      if (tocf!=NULL) fclose(tocf);
      if (!lockedflg) unlock_mbox();
    next:
      if (toch) { free(toch); toch=0; }
      if (mi) { free(mi); mi=0; }
      uncd_mbox();
   }
   POOL_RELEASE
   return EXIT_SUCCESS;
}
