/*+++*
 *  title:	optutil.c
 *  RCS         optutil.c,v 1.7 1998/10/30 00:09:37 tom Exp
 *  abstract:	command-line option handling support stuff.
 *  author:	Tom Hageman, The Netherlands <tom@basil.icce.rug.nl>
 *  created:	November 1996
 *  modified:	31 May 1997
 *---*/

#import <stdio.h>
#import <stdlib.h>
#import <string.h>
#import <time.h>

#import "compat.h"
#import "optutil.h"
#import "version.h"

#if NEXTSTEP
#   define OSVERSION	"NEXTSTEP"
#elif OPENSTEP
#   define OSVERSION	"OPENSTEP"
#elif RHAPSODY
#   define OSVERSION	"Rhapsody"
#else
#   define OSVERSION	"unknown"
#endif

const char *basename(const char *path)
{
   const char *s = strrchr(path, '/');

   return (s ? ++s : path);
}

const char *_progname = "(unset)";

#ifndef __GNUC__
void set_progname(const char *name)  { _progname = basename(name); }
const char *progname()               { return _progname; }
#endif

int check_arg_for_long_help_version(const char *arg)
{
   if (arg && arg[0] == '-' && arg[1] == '-' && arg[2])
   {
      int len = strlen(arg);

      if (strncmp("--version", arg, len) == 0) return EXIT_VERSION;
      if (strncmp("--help",    arg, len) == 0) return EXIT_HELP;
      return EXIT_USAGE;
   }
   return EXIT_SUCCESS;
}

void handle_usage_help_version(int what, const char *usage, const char *help)
{
   switch (what)
   {
   case EXIT_USAGE:
      fprintf(stderr, usage, progname());
      fprintf(stderr, "try `%s --help' (or -H) for more information.\n", progname()); 
      break;
   case EXIT_HELP:
      printf(usage, progname());
      printf(help, progname());
      what = EXIT_SUCCESS;
      break;
   case EXIT_VERSION:
      printf("%s: %s version %s, %s. (%s)\n",
             progname(), PACKAGE, VERSION, VERSION_DATE, OSVERSION);
      what = EXIT_SUCCESS;
      break;
   default:
      return; /* no-op. */
   }
   exit(what);
}


extern int getpid();

static BOOL log_show_time = NO, log_show_pid = NO;

void logprintf(const char *format, ...)
{
   va_list ap;
   char timestr[40], pidstr[20];

   timestr[0] = '\0';
   pidstr[0] = '\0';

   if (log_show_time)
   {
      time_t now;

      time(&now);
      /* standard syslog format, e.g. "Jul 04 14:05:10" */
      strftime(timestr, sizeof(timestr), "%b %d %H:%M:%S ", localtime(&now));
   }
   if (log_show_pid)
   {
      sprintf(pidstr, "[%d]", getpid());
   }
   fprintf(stderr, "%s%s%s: ", timestr, progname(), pidstr);
   va_start(ap, format);
   vfprintf(stderr, format, ap);
   va_end(ap);
   putc('\n', stderr);
}

int log_set_show_time(int value)
{
   BOOL oldValue = log_show_time;

   if (value != -1) log_show_time = value;
   return oldValue;
}

int log_set_show_pid(int value)
{
   BOOL oldValue = log_show_pid;

   if (value != -1) log_show_pid = value;
   return oldValue;
}
