/*+++*
 *  title:	optutil.h
 *  RCS         optutil.h,v 1.5 1998/10/23 19:58:11 tom Exp
 *  abstract:	command-line option handling support stuff.
 *  author:	Tom Hageman, The Netherlands <tom@basil.icce.rug.nl>
 *  created:	November 1996
 *  modified:	23-Oct-1998
 *---*/

#define EXIT_USAGE	2

// dummy exit codes -- the calling process never sees these.
#define EXIT_HELP	(-2)
#define EXIT_VERSION	(-3)

#if (!defined(__GNUC__) || (__GNUC__ < 2)) && !defined(__attribute__)
#  define __attribute__(x) /*empty*/
#endif

const char *basename(const char *path);

extern const char *_progname;

#if __GNUC__
static inline void set_progname(const char *name)  { _progname=basename(name); }
static inline const char *progname()               { return _progname; }
#else
void set_progname(const char *name);
const char *progname();
#endif

int check_arg_for_long_help_version(const char *arg);   /* returns status. */

void handle_usage_help_version(int what, const char *usage, const char *help);

// log message support.
void logprintf(const char *format, ...) __attribute__((format(printf,1,2)));
int log_set_show_time(int value);
int log_set_show_pid(int value);
