/*
    File:       QResourceEnumerator.h

    Contains:   An enumerator that returns all the resources of a given type
                in a resource file.

    Written by: Quinn "The Eskimo!"

    Created:    Mon 19-May-1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import <AppKit/AppKit.h>

#import "QResourceObject.h"

@class QResourceFile;

@interface QResourceEnumerator : NSEnumerator
{
    QResourceFile *resFile;		// The resource file we're enumerating.
    QResourceType resType;		// The resource type we're looking for.
    long resourceIndex;			// The index of the next resource to return.
    long numResourcesOfThisType;	// The count of the number of resources of resType in resFile.
    long referenceListOffset;		// Offset (in bytes) to the resource reference list for resType in resFile.
}

- (id)initWithResourceFile:(QResourceFile*)resFile andType:(QResourceType)aResType;
    // Initialise a newly allocated object to enumerate the resources of type aResType
    // in the resource file denoted by resFile.

- (QResourceObject *)nextObject;
    // Returns the next resource of the originally specified type.

@end
