/*
    File:       QStringList.m

    Contains:   A class for accessing Mac OS 'STR#' data structures.

    Written by: Quinn "The Eskimo!"

    Created:    Tue 20-May-1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import "QStringList.h"
#import "QMacDataAccess.h"

@implementation QStringList

+ (QStringList *)stringListWithData:(NSData *)theData
    // See comments in interface part.
{
    return [ [ [QStringList alloc] initWithData:theData ] autorelease ];
}

- (QStringList *)initWithData:(NSData *)theData
    // See comments in interface part.
{
    self = [super init];
    if ( self != nil ) {
        
        NSAssert( theData != nil, @"No data for string list");

        NSAssert( [theData length] >= 2, @"Data to small for string list");

        // More validation code should go here but I haven't had time
        // to write it yet.
        
        listData = theData;
        [listData retain];
    }
    return self;
}

- (id)init
    // Call through to the designated initialiser.
    // In the non-subclassed case, we violate the pre-condition of the
    // designated initialiser by passing in a nil path pointer.
    // We do this because a) it's the right thing to do (see the book
    // "Object-Oriented Programming and the Objective-C Language" for
    // the reasoning), and b) a subclasser may want to subclass us in a
    // weird way.
{
    return ( [self initWithData:nil] );
}

- (long)count
    // See comments in interface part.
{
    return [listData MacUInt16AtOffset:0];
}

- (NSString *)stringAtIndex: (long)index
    // See comments in interface part.
{
    UInt32 offset;
    
    NSAssert( (1 <= index) && (index <= [self count]), @"stringAtIndex range check failed" );
    offset = 2;
    while ( index > 1 ) {
        offset = offset + [listData MacUInt8AtOffset:offset] + 1;
        index--;
    }

    return [listData MacPStringAtOffset:offset];
}

- (NSString *) description
    // See comments in interface part.
{
    return [NSString stringWithFormat:@"String list with %d strings", [self count] ];
}

- (void) dealloc
    // See comments in interface part.
{
    [listData release];
    [super dealloc];
}

@end

