#import <AppKit/AppKit.h>

/*
 File:       MagnifyingGlassController.h

 Contains:   Header file for the MagnifyingGlassController class

 Written by: Eric Simenel

 Created:    July 1997

 Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

 Change History (most recent first):

 You may incorporate this sample code into your applications without
 restriction, though the sample code has been provided "AS IS" and the
 responsibility for its operation is 100% yours.  However, what you are
 not permitted to do is to redistribute the source as "DSC Sample Code"
 after having made changes. If you're going to re-distribute the source,
 we require that you make it clear in the source that the code was
 descended from Apple Sample Code, but that you've made changes.
*/

@interface MagnifyingGlassController : NSObject
{
    id magnifiedView;
    id xAnchoredLocation;
    id xGlobalLocation;
    id yAnchoredLocation;
    id yGlobalLocation;

    NSPoint anchor;
    NSPoint globalLocation;

    BOOL imageIsLocked;
    id lockImageMenuItem;
    id unlockImageMenuItem;
}

- (void)setAnchor:(NSPoint)point;
- (void)setGlobalLocation:(NSPoint)point;
- (void)anchorMouseLocation:(id)sender;
- (BOOL)imageIsLocked;
- (void)lockImage:(id)sender;
- (void)unlockImage:(id)sender;

// to correctly enable/disable the lock/unlock menu items
- (BOOL)validateMenuItem:(id <NSMenuItem>)menuItem;

@end
