#import <AppKit/AppKit.h>

/*
 File:       MagnifyingView.h

 Contains:   Header file for the MagnifyingView class

 Written by: Eric Simenel

 Created:    July 1997

 Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

 Change History (most recent first):

 You may incorporate this sample code into your applications without
 restriction, though the sample code has been provided "AS IS" and the
 responsibility for its operation is 100% yours.  However, what you are
 not permitted to do is to redistribute the source as "DSC Sample Code"
 after having made changes. If you're going to re-distribute the source,
 we require that you make it clear in the source that the code was
 descended from Apple Sample Code, but that you've made changes.
*/

@interface MagnifyingView : NSView
{
    id			magnifyingGlassController;
    NSWindow		*grabWindow;
    NSBitmapImageRep	*screenBitmap;
    NSRect		lastScreenBitmapRect;
}

- (id)initWithFrame:(NSRect)rect;
- (void)dealloc;
- (void)drawRect:(NSRect)rect;
- (BOOL)acceptsFirstResponder;
- (BOOL)becomeFirstResponder;
- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent;
- (void)mouseUp:(NSEvent *)theEvent;
- (void)mouseMoved:(NSEvent *)theEvent;

@end
