/* WavyView.m created by epeyton on Wed 28-Apr-1999 */

#import "WavyView.h"

#define	RAND_MAX	0x7fffffff

float randBetweenForWavy(float a, float b)
{
    float	val, scale, t;

    if (a > b) {
        t = a; a = b; b = t;
    }

    scale = (b - a);
    val = scale * ((float) random() / (float) RAND_MAX);
    return (a + val);
}

@implementation WavyView


- (BOOL)useBufferedWindow
{
    return YES;
}

- (id)initWithFrame:(NSRect)frameRect
{
    int x;
    
    if (![super initWithFrame:frameRect]) return nil;

    modes = calloc([self bounds].size.width * [self bounds].size.height, sizeof(x));
    
    [self allocateGState];
    srandom(time(0));

    return self;
}

- (NSView *)inspector:sender
{
    if (!sharedInspectorPanel) {
        [NSBundle loadNibNamed:@"WavyScreen.nib" owner:self];
    }

    return sharedInspectorPanel;
}


//
// The Graphics Code
//

- (void)drawRect:(NSRect)rects
{
}

- (void)oneStep
{
    int i = 0;
    static int x = 0;

    //melt a few rows on the screen
    while (i < 400) {
        //int z = floor(randBetweenForWavy(-5.0, 5.0));  // amount to move
        static int z = 0;
        static int direction = 1;
        int move = 0;

        if (z > 20) {
            direction = -1;
        } else if ( z < -20) {
            direction = 1;
        }

        z = z + direction;

        move = floor((z + 1)/2);

        /*switch (z) {
            case -12:
            case -11:
                move = -6;
                break;
            case -10:
            case -9:
                move = -5;
                break;
            case -8:
            case -7:
                move = -4;
                break;
            case -6:
            case -5:
                move = -3;
                break;
            case -4:
            case -3:
                move = -2;
                break;
            case -2:
            case -1:
                move = -1;
                break;
            case 0:
                move = 0;
                break;
            case 1:
            case 2:
                move = 1;
                break;
            case 3:
            case 4:
                move = 2;
                break;
            case 5:
            case 6:
                move = 3;
                break;
            case 7:
            case 8:
                move = 4;
                break;
            case 9:
            case 10:
                move = 5;
                break;
            case 11:
            case 12:
                move = 6;
                break;
            default:
                move = 0;
                break;
        } */
            
        
        if (x > [self bounds].size.width) {
            x = 0;
        }
        x = x + floor(randBetweenForWavy(1.0, 4.0));
        {
            
        	NSPoint point = NSMakePoint(x,0 - move);
        	NSRect rect = NSMakeRect(x,0,1,[self bounds].size.height);
        	[buffer compositeToPoint:point fromRect:rect operation:NSCompositeSourceOver];
        }

        
        
        i++;
    }
    
    return;
}

- (void)willEnterScreenSaverMode
{
    [self loadBuffer];
}

- (void)willExitScreenSaverMode
{
    if (buffer) {
        [buffer release];
        buffer = nil;
    }
}

// this will probably break in Mac OS X.
- (void)loadBuffer
{
   id snapShot;
   NSSize screen;
   NSRect imageRect = NSMakeRect(0,0,0,0);

   screen = [self bounds].size;
   imageRect.size = screen;
   snapShot = [[NSWindow alloc] initWithContentRect:imageRect
                                          styleMask:NSBorderlessWindowMask
                                            backing:NSBackingStoreNonretained
                                              defer:NO];
   PSsetwindowlevel(NSPopUpMenuWindowLevel,[snapShot windowNumber]);
   PSsetautofill(NO,[snapShot windowNumber]);
   [snapShot orderFront:self];
   if (!buffer) {
           buffer = [[NSImage alloc] initWithSize:screen];
   }
   [buffer lockFocus];
   PScomposite(0.0,0.0,screen.width,screen.height,[snapShot gState],
               0.0,0.0,NSCompositeCopy);
   [buffer unlockFocus];
   [snapShot release];
}


@end
