// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OWF/Content.subproj/Address.subproj/OWURL.h,v 1.6 1998/12/08 04:05:48 kc Exp $

#import <OmniFoundation/OFObject.h>

@class OWContentType, OWNetLocation;

#import <Foundation/NSString.h> // For NSStringEncoding

@interface OWURL : OFObject <NSCopying>
{
    // Basic attributes
    NSString *scheme;

    // Common scheme attributes
    NSString *netLocation;
    NSString *path;
    NSString *params;
    NSString *query;
    NSString *fragment;

    // Irregular scheme attribute
    NSString *schemeSpecificPart;

    // Derived attributes
    NSString *cachedCompositeString;
    NSString *cachedShortDisplayString;
    OWNetLocation *cachedParsedNetLocation;
    NSString *cacheKey;
    OWContentType *contentType;
}

+ (void)readDefaults;
+ (void)setURLEncoding:(NSStringEncoding)newURLEncoding;
+ (NSStringEncoding)urlEncoding;

+ (OWURL *)urlWithScheme:(NSString *)aScheme netLocation:(NSString *)aNetLocation path:(NSString *)aPath params:(NSString *)someParams query:(NSString *)aQuery fragment:(NSString *)aFragment;
+ (OWURL *)urlWithScheme:(NSString *)aScheme schemeSpecificPart:(NSString *)aSchemeSpecificPart fragment:(NSString *)aFragment;
+ (OWURL *)urlFromString:(NSString *)aString;
+ (OWURL *)urlFromDirtyString:(NSString *)aString;

+ (NSString *)cleanURLString:(NSString *)aString;
+ (NSString *)decodeURLString:(NSString *)aString;
+ (NSString *)encodeURLString:(NSString *)unencodedString asQuery:(BOOL)asQuery leaveSlashes:(BOOL)leaveSlashes leaveColons:(BOOL)leaveColons;
+ (NSString *)encodeURLString:(NSString *)unencodedString encoding:(NSStringEncoding)thisUrlEncoding asQuery:(BOOL)asQuery leaveSlashes:(BOOL)leaveSlashes leaveColons:(BOOL)leaveColons;

+ (OWContentType *)contentTypeForScheme:(NSString *)aScheme;

+ (NSArray *)pathComponentsForPath:(NSString *)aPath;
+ (NSString *)lastPathComponentForPath:(NSString *)aPath;
+ (NSString *)stringByDeletingLastPathComponentFromPath:(NSString *)aPath;

- (NSString *)scheme;

// Common scheme attributes
- (NSString *)netLocation;
- (NSString *)path;
- (NSString *)params;
- (NSString *)query;
- (NSString *)fragment;

// Irregular scheme attribute
- (NSString *)schemeSpecificPart;

// Derived attributes
- (NSString *)compositeString;
- (NSString *)cacheKey;
- (NSString *)fetchPath;
- (NSString *)proxyFetchPath;
- (NSArray *)pathComponents;
- (NSString *)lastPathComponent;
- (NSString *)stringByDeletingLastPathComponent;
- (OWNetLocation *)parsedNetLocation;
    // Many net locations have the form username:password@hostname:port

- (NSString *)shortDisplayString;

- (BOOL)isEqual:(id)anObject;

- (OWContentType *)contentType;

// Creating related URLs

- (OWURL *)urlFromRelativeString:(NSString *)aString;
- (OWURL *)urlForPath:(NSString *)newPath;
- (OWURL *)urlForQuery:(NSString *)newQuery;
- (OWURL *)urlWithoutFragment;	// N.B.: may return self
- (OWURL *)urlWithFragment:(NSString *)newFragment;

@end
