// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OWFTPProcessor.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import "OWAddress.h"
#import "OWFTPSession.h"
#import "OWSourceProcessor.h"
#import "OWURL.h"

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OWF/Processors.subproj/Protocols.subproj/OWFTPProcessor.m,v 1.3 1998/12/08 04:06:00 kc Exp $")

@implementation OWFTPProcessor

+ (void)didLoad;
{
    [self registerProcessorClass:self fromContentType:[OWURL contentTypeForScheme:@"ftp"] toContentType:[OWSourceProcessor sourceContentType] cost:1.0];
}

- initWithPipeline:(OWPipeline *)aPipeline;
{
    if (![super initWithPipeline:aPipeline])
	return nil;

    ftpAddress = [(OWAddress *)[pipeline lastContent] retain];

    return self;
}

- (void)dealloc;
{
    [ftpAddress release];
    [super dealloc];
}

- (void)process;
{
    ftpSession = [OWFTPSession ftpSessionForAddress:ftpAddress];
    [ftpSession fetchForProcessor:self inPipeline:pipeline];
    ftpSession = nil;
}

- (void)abortProcessing;
{
    [ftpSession abortOperation];
    ftpSession = nil;
    [super abortProcessing];
}

@end
