// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OWSGMLDTD.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import "OWContentType.h"
#import "OWSGMLTagType.h"

@implementation OWSGMLDTD

static NSMutableDictionary *dtdForType;

+ (void)initialize;
{
    static BOOL                 initialized = NO;

    [super initialize];

    if (initialized)
        return;

    initialized = YES;
    dtdForType = [[NSMutableDictionary alloc] init];
}

+ (OWSGMLDTD *)dtdForSourceContentType:(OWContentType *)aSourceType;
{
    return [dtdForType objectForKey:[aSourceType contentTypeString]];
}

+ (NSArray *)allDTDs;
{
    return [dtdForType allValues];
}

- initWithSourceType:(OWContentType *)aSource 
    destinationType:(OWContentType *)aDestination;
{
    [super init];
    sourceType = [aSource retain];
    destinationType = [aDestination retain];
    tagTrie = [[OFTrie alloc] initCaseSensitive:NO];
    [dtdForType setObject:self forKey:[sourceType contentTypeString]];
    tagCount = 0;
    return self;
}

- (OFTrie *)tagTrie;
{
    return tagTrie;
}

- (OWContentType *)sourceType;
{
    return sourceType;
}

- (OWContentType *)destinationType;
{
    return destinationType;
}

- (unsigned int)tagCount;
{
    return tagCount;
}

- (OWSGMLTagType *)tagTypeNamed:(NSString *)aName;
{
    OWSGMLTagType *tagType;

    tagType = (OWSGMLTagType *)[tagTrie bucketForString:aName];

    if (!tagType) {
        tagType = [[OWSGMLTagType alloc] initWithName:aName dtdIndex:tagCount++];
        [tagTrie addBucket:tagType forString:aName];
        [tagType release];
    }
    return tagType;
}

- (BOOL)hasTagTypeNamed:(NSString *)aName;
{
    return [tagTrie bucketForString:aName] != nil;
}

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary        *debugDictionary;

    debugDictionary = [super debugDictionary];

    [debugDictionary setObject:tagTrie forKey:@"tagTrie"];
    [debugDictionary setObject:sourceType forKey:@"sourceType"];
    [debugDictionary setObject:destinationType forKey:@"destinationType"];
    [debugDictionary setObject:[NSString stringWithFormat:@"%d", tagCount] forKey:@"tagCount"];

    return debugDictionary;
}

@end
