// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OWSGMLObjectsToXMLTree.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import "OWSGMLTag.h"
#import "OWSGMLTagType.h"
#import "OWObjectTree.h"
#import "OWObjectTreeNode.h"
#import "OWObjectStreamCursor.h"
#import "OWPipeline.h"

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OWF/Processors.subproj/SGML.subproj/OWSGMLObjectsToXMLTree.m,v 1.3 1998/12/08 04:06:15 kc Exp $")

@implementation OWSGMLObjectsToXMLTree

- (void)dealloc;
{
    [root release];
    [super dealloc];
}

- (void)process
{
    id <OWSGMLToken> sgmlToken;

    while((sgmlToken = [objectCursor readObject])) {
        switch ([sgmlToken tokenType]) {
            case OWSGMLTokenTypeStartTag:
                if (!currentNode) {
                    root = [[OWObjectTree alloc] initWithRepresentedObject:sgmlToken];
                    // should set the content type
                    [pipeline addContent:root];
                    currentNode = root;
                    break;
                }
                // fall through
            case OWSGMLTokenTypeCData:
                [currentNode addChild:sgmlToken];
                break;
            case OWSGMLTokenTypeEndTag:
            {
                OWSGMLTag *tag = (OWSGMLTag *)[currentNode representedObject];

                if (sgmlTagType(tag) != sgmlTagType((OWSGMLTag *)sgmlToken)) {
                    // should abort here
                } else {
                    [currentNode childrenEnd];
                    currentNode = [currentNode parent];
                }
                break;
            }
            default:
                break;
        }
    }
}

@end
