// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OWF/Processors.subproj/SGML.subproj/OWSGMLTagType.h,v 1.4 1998/12/08 04:06:16 kc Exp $

#import <OmniFoundation/OFTrieBucket.h>

@class NSArray, NSMutableArray;
@class OFTrie;
@class OWSGMLTag;

@interface OWSGMLTagType : OFTrieBucket
{
@public
    NSString *name;
    unsigned int dtdIndex;
    OWSGMLTagType *masterAttributesTagType;
    NSMutableArray *attributeNames;
    OFTrie *attributeTrie;
    BOOL isNotValidSGML;

    OWSGMLTag *attributelessStartTag;
    OWSGMLTag *attributelessEndTag;
}

- initWithName:(NSString *)aName dtdIndex:(unsigned int)anIndex;

- (NSString *)name;
- (unsigned int)dtdIndex;
- (OWSGMLTagType *)masterAttributesTagType;
- (NSArray *)attributeNames;
- (OFTrie *)attributeTrie;
- (BOOL)isNotValidSGML;

- (void)shareAttributesWithTagType:(OWSGMLTagType *)aTagType;
- (unsigned int)addAttributeNamed:(NSString *)attributeName;
- (unsigned int)indexOfAttribute:(NSString *)attributeName;
- (BOOL)hasAttributeNamed:(NSString *)attributeName;

- (OWSGMLTag *)attributelessStartTag;
- (OWSGMLTag *)attributelessEndTag;

@end

static inline unsigned int tagTypeDtdIndex(OWSGMLTagType *tagType)
{
    return tagType->dtdIndex;
}
