
#import "BackView.h"
#import "Ship.h"
#import "Thinker.h"
#import "CacheManager.h"
#import "ActorMgr.h"

float xOffset, yOffset;
NSRect screenRect;

@implementation BackView

- initWithFrame:(NSRect)frameRect
{
	[super initWithFrame:frameRect];
	[self allocateGState];		// For faster lock/unlockFocus
	[self newSize];
	return self;
}

- (void)setFrameSize:(NSSize)_newSize
{
	[super setFrameSize:_newSize];
	[self newSize];
}

- (void)drawRect:(NSRect)rects
{
  NSRect t = {{0,0},{1,1}};
	PSsetrgbcolor(1,0,0);
	NSRectFill(t);	//yucky trick for window depth promotion!
	PSsetgray(NSBlack); NSRectFill(rects);
	[(CacheManager *)cacheMgr draw];
	[(ActorMgr *)actorMgr draw];
}

- (void)keyDown:(NSEvent *)theEvent 
{
//	switch(theEvent->data.key.charCode)
	{
//		default:
			[scenario keyDown:theEvent];
//			break;
	}
}

- (void)keyUp:(NSEvent *)theEvent 
{
	[scenario keyUp:theEvent];
}

- newSize
{
	xOffset = [self bounds].size.width/2;
	yOffset = [self bounds].size.height/2;

	screenRect = [self bounds];

	[cacheMgr newSize:[self bounds].size];
	if ([scenario respondsToSelector:@selector(newSize:)])
		[scenario newSize:[self bounds].size];

	return self;
}

- (BOOL) acceptsFirstResponder
{	return YES;
}

@end


@implementation NSWindow(Sizing)

#define CORNER_UPPER_LEFT	0
#define CORNER_LOWER_LEFT	1
#define CORNER_UPPER_RIGHT	2
#define CORNER_LOWER_RIGHT	3

// Keep 'a' between x and y
#define CLAMP(a,x,y) (MAX((x), MIN((y), (a))))

/******************************************************************************
	This Method resizes the receiving window as if it was dragged with the given corner. This method is useful when you want the window to resize by a corner other that the default upper right.
******************************************************************************/
- sizeWindow:(float)width :(float)height byCorner:(int)corner
{
	NSRect newFrame;
	NSSize minSize, maxSize;

	// Clamp width and height to their respective minimum and maximum values
	minSize = [self minSize]; maxSize = [self maxSize];
	width = CLAMP(width, minSize.width, maxSize.width);
	height = CLAMP(height, minSize.height, maxSize.height);

	// Set newFrame from the old frame and the new sizes
	newFrame = NSMakeRect(NSMinX([self frame]), NSMinY([self frame]), width, height);

	// Move the respective corner by the amount of growth and set newFrame
	switch(corner) {
		case CORNER_UPPER_LEFT:
			(&newFrame)->origin.x -= width - NSWidth([self frame]);
			break;
		case CORNER_LOWER_LEFT:
			(&newFrame)->origin.x -= width - NSWidth([self frame]);
			(&newFrame)->origin.y -= height - NSHeight([self frame]);
			break;
		case CORNER_UPPER_RIGHT:
			break;
		case CORNER_LOWER_RIGHT:
			(&newFrame)->origin.y -= height - NSHeight([self frame]);
			break;
	}
	[self setFrame:newFrame display:YES];
	return self;
}
@end

@implementation NSView(Sizing)

/******************************************************************************
	This Method resizes the receiving view to the given width and height by resizing the window by the appropriate amount with respect to autosizing. This method is useful for those occasions when you know what size a view should be, but don't know how big to make the window to hold it. If you ask for a new width, it assumes the view is width sizable. The same goes for height. If the hierarchy contains a ClipView (ie, in a ScrollView) it assumes that you want the ClipView's subview to be fully exposed. The window size will not exceed the set maximum.
******************************************************************************/
- sizeTo:(float)width :(float)height byWindowCorner:(int)corner
{
  NSRect bounds = [self bounds];
  id window = [self window];
  id superview = [self superview];
  int autosizing = [self autoresizingMask];
  float widthGrowth = width - NSWidth([self bounds]);
  float heightGrowth = height - NSHeight([self bounds]);
  float stretchingWidth = NSWidth(bounds);
  float stretchingHeight = NSHeight(bounds);
  float newSuperWidth, newSuperHeight;
  NSRect superFrame;
  NSRect frame = [self frame];
  // If we are a contentView we simply need to grow window by our growth
  if(self==[[self window] contentView]) {
    superFrame = [window frame];
    [window sizeWindow:NSWidth(superFrame) + widthGrowth
                                           :NSHeight(superFrame) + heightGrowth byCorner:corner];
    }
  else {
    superFrame = [[self superview] frame];

    // Add margins to stretching lengths if they have been turned on in IB
    if(autosizing & NSViewMinXMargin) stretchingWidth += NSMinX(frame);
    if(autosizing & NSViewMaxXMargin)
      stretchingWidth += NSWidth(superFrame) - NSMaxX(frame);
    if(autosizing & NSViewMinYMargin)
      stretchingHeight += NSMinY(frame);
    if(autosizing & NSViewMaxYMargin)
      stretchingHeight += NSHeight(superFrame) - NSMaxY(frame);

    // Add growth times a ratio of stetching length::view length to Super
    newSuperWidth = NSWidth(superFrame) +
      widthGrowth*stretchingWidth/NSWidth(bounds);
    newSuperHeight = NSHeight(superFrame) +
      heightGrowth*stretchingHeight/NSHeight(bounds);

    // Resize the Superview
    [superview sizeTo:newSuperWidth :newSuperHeight
                            byWindowCorner:corner];

    // If we are a ClipView, bring the docview up to size
    if([self isKindOfClass:[NSClipView class]])
      [[(NSClipView *)self documentView] setFrameSize:NSMakeSize(width, height)];
    }
  return self;
}


@end

