
#import "DF_Ground.h"
#import "ActorMgr.h"
#import "SoundMgr.h"
#import "CacheManager.h"
#import "Defender.h"
#import "Thinker.h"
#import "xoxDefs.h"

@implementation DF_Ground

#define WORLDWIDTH (3500)
#define NPOINTS (15)
#define NSEGS (NPOINTS-1)

// assumptions are made in df_heightAt() that all slopes are 45
// degrees, though that could be fixed easily
static NSPoint contours[NPOINTS] = {
  {0,0},
  {600,0},
  {900,300},
  {1200,0},
  {1600,0},
  {1800,200},
  {2000,0},
  {2200,0},
  {2300,100},
  {2600,100},
  {2800,300},
  {3000,100},
  {3200,100},
  {3300,200},
  {WORLDWIDTH,0}
  };

- init
{
	[super init];
    drawPath = newUserPath();
    erasePath = newUserPath();
	return self;
}

- activate:sender :(int)tag
{
	NSSize tsize = {WORLDWIDTH,300};
	NSSize tsize2 = {1750,150};

	[super activate:sender :tag];

	[self reinitWithImage:@"df_nullimage"
		frameSize:&tsize
		numFrames:1
		shape: RECT
		alliance: NEUTRAL
		radius: tsize2.width
		buffered: NO
		x: 0
		y: 0
		theta: 0
		vel: 0
		interval: 0
		distToCorner: &tsize2];

	return self;
}


- scheduleDrawing
{
	[displayMgr draw:self];
	return self;
}

#define GRND_HT (50)
static float tx;

static void drawLine(DF_Ground *self, XXLine *ln)
{
	UPmoveto(self->drawPath, xOffset+(ln->x1-tx),
		GRND_HT + ln->y1);
	UPlineto(self-> drawPath, xOffset+(ln->x2-tx),
		GRND_HT + ln->y2);
	if (ln->y1 != ln->y2)
	{
		UPmoveto(self-> drawPath, xOffset+(ln->x1-tx),
			GRND_HT - 1 + ln->y1);
		UPlineto(self-> drawPath, xOffset+(ln->x2-tx),
			GRND_HT - 1 + ln->y2);
	}
}

- draw
{
	int i;
	float tf=gx;
	BOOL mirrored = NO;
	UserPath *tpath;
	XXLine *contourLine;
	int drawCase = 1;

	tpath = drawPath; drawPath = erasePath; erasePath = tpath;

	if (tf < 0)
	{
		tf = 0 - tf;
		mirrored = YES;
	}

	tx = ((int)tf) % WORLDWIDTH;
	if (mirrored) tx = WORLDWIDTH - tx;

	// translation now normalized into 0 - WORLDWIDTH range

	if (tx - xOffset < 0.) drawCase = 0;
	else if (tx + xOffset > WORLDWIDTH) drawCase = 2;

	beginUserPath(drawPath,YES);

	switch (drawCase)
	{
	case 0:
		// include a piece from far end
		for (i=0; i<NSEGS; i++)
		{
			contourLine = (XXLine *)(&contours[i]);
			if (contourLine->x1 < tx + xOffset)
			{
				drawLine(self,contourLine);
			}
			else break;
		}
		for (i=NSEGS-1; i>=0; i--)
		{
			contourLine = (XXLine *)(&contours[i]);
			if (contourLine->x2 > tx + WORLDWIDTH - xOffset)
			{
				UPmoveto(drawPath, xOffset+(contourLine->x1-tx-WORLDWIDTH),
					GRND_HT + contourLine->y1);
				UPlineto(drawPath, xOffset+(contourLine->x2-tx-WORLDWIDTH),
					GRND_HT + contourLine->y2);
				if (contourLine->y1 != contourLine->y2)
				{
				UPmoveto(drawPath, xOffset+(contourLine->x1-tx-WORLDWIDTH),
					GRND_HT -1 + contourLine->y1);
				UPlineto(drawPath, xOffset+(contourLine->x2-tx-WORLDWIDTH),
					GRND_HT -1 + contourLine->y2);
				}
			}
			else break;
		}
		break;

	case 1:
		// entire world within view
		for (i=0; i<NSEGS; i++)
		{
			contourLine = (XXLine *)(&contours[i]);
			if ((contourLine->x1 >= tx - xOffset && 
					contourLine->x1 < tx + xOffset) ||
				(contourLine->x2 >= tx - xOffset && 
					contourLine->x2 < tx + xOffset))
			{
				drawLine(self,contourLine);
			}
		}
		// fixme optimize to stop when off end...
		break;

	case 2:
		// include a piece from beginning
		for (i=0; i<NSEGS; i++)
		{
			contourLine = (XXLine *)(&contours[i]);
			if (contourLine->x1 < tx - WORLDWIDTH + xOffset)
			{
				UPmoveto(drawPath, xOffset+(contourLine->x1-tx+WORLDWIDTH),
					GRND_HT + contourLine->y1);
				UPlineto(drawPath, xOffset+(contourLine->x2-tx+WORLDWIDTH),
					GRND_HT + contourLine->y2);
				if (contourLine->y1 != contourLine->y2)
				{
				UPmoveto(drawPath, xOffset+(contourLine->x1-tx+WORLDWIDTH),
					GRND_HT -1 + contourLine->y1);
				UPlineto(drawPath, xOffset+(contourLine->x2-tx+WORLDWIDTH),
					GRND_HT -1 + contourLine->y2);
				}
			}
			else break;
		}
		for (i=NSEGS-1; i>=0; i--)
		{
			contourLine = (XXLine *)(&contours[i]);
			if (contourLine->x2 > tx - xOffset)
			{
				drawLine(self,contourLine);
			}
			else break;
		}
		break;

	}

	endUserPath(drawPath,dps_ustroke); // close user path and specify operator
    PSsetgray(0.0);
	sendUserPath(erasePath);
	PSsetrgbcolor(1,.2,.2);
	sendUserPath(drawPath);

	return self;
}

float df_heightAt(float hx)
{
	float tf=hx;
	BOOL mirrored = NO;
	int i;

	if (tf < 0)
	{
		tf = 0 - tf;
		mirrored = YES;
	}

	tf = ((int)tf) % WORLDWIDTH;
	if (mirrored) tf = WORLDWIDTH - tf;

	// translation now normalized into 0 - WORLDWIDTH range

	// should really do a binary search?
	for (i=1; i<NPOINTS; i++)
	{
		int slope;
		if (tf < contours[i].x)
		{
			slope = 0;
			if (contours[i-1].y < contours[i].y) slope = 1;
			else if (contours[i-1].y > contours[i].y) slope = -1;
			return GRND_HT + contours[i-1].y + (slope * (tf-contours[i-1].x)); 
		}
	}

	return GRND_HT + contours[NPOINTS-1].y;
}
@end
