
#import "DF_Ship.h"
#import "DF_Alien.h"
#import "DF_People.h"
#import "ActorMgr.h"
#import "SoundMgr.h"
#import "../CommonEffects.bproj/Bullet.h"
#import "Defender.h"
#import "../Thinker.h"

#define ACCEL (4.0)
#define MAXV (70)
#define DECEL (0.2)
#define VERTSPEED (31.0)

extern float gx, gy;

@implementation DF_Ship

- activate:sender :(int)tag
{
	NSSize t20 = {60,25};
	NSSize t10 = {30,12.5};

	[super activate:sender :tag];

	[self reinitWithImage:@"dfship"
		frameSize:&t20
		numFrames:6
		shape: RECTCIRC
		alliance: DESTROYALL
		radius: 13
		buffered: YES
		x: 0.0
		y: 0.0
		theta: -PI/2.0
		vel: 0.0
		interval: 50
		distToCorner: &t10];

	[self setThrusting:NO time:0];
	xv = yv = gx = gy = gDelta = 0;
	thrustOffset = frame = 0;

	return self;
}

+ (void)initialize
{
	[super initialize];
	[[NSApp delegate] addImageResource:"dfship" for: [DF_Ship class]];

	return;
}

- init
{
	[super init];

	thrustVal = [[KeyTimer allocWithZone:[self zone]] init];
	upVal = [[KeyTimer allocWithZone:[self zone]] init];
	downVal = [[KeyTimer allocWithZone:[self zone]] init];
	[upVal setDelegate:downVal];
	[downVal setDelegate:upVal];

	return self;
}

- (void)dealloc
{
	[thrustVal release];
	[upVal release];
	[downVal release];
	{ [super dealloc]; return; };
}

- setThrusting:(BOOL)val time:(long)time
{
	thrusting = val;
	if (thrusting)
	{
		changeTime = timeInMS + interval;
		[thrustVal keyDownAt:time];
	}
	else
	{
		frame = thrustOffset;
		if (time) [thrustVal keyUpAt:time];
	}

    return self;
}

- setElevation:(ROTATION)dir down:(BOOL)keyDn time:(long)time
{
	if (dir == LEFT)
	{
		if (keyDn) [upVal keyDownAt:time];
		else [upVal keyUpAt:time];
	}
	else if (dir == RIGHT)
	{
		if (keyDn) [downVal keyDownAt:time];
		else [downVal keyUpAt:time];
	}
	return self;
}

- turn
{
	if (theta < 0)
	{
		theta = PI/2.0;
		thrustOffset = frame = 3;
	}
	else
	{
		theta = -PI/2.0;
		thrustOffset = frame = 0;
	}
	changeTime = timeInMS;
	return self;
}

- positionChanged
{
	float desiredDelta, dDelta, dmax = 15.0*timeScale;

	desiredDelta = (.5 * xOffset * xv / MAXV)
		+ (theta < 0 ? (.2 * xOffset) : (-0.2 * xOffset));
	dDelta = MAX(-dmax,(MIN(dmax, (desiredDelta-gDelta))));

	gDelta += dDelta;
	gx = x + gDelta;

	if (y > yOffset - distToCorner.height)
		[self setFrameOrigin:NSMakePoint(x, yOffset - distToCorner.height)];
	else if (y < -yOffset + distToCorner.height)
		[self setFrameOrigin:NSMakePoint(x, -yOffset + distToCorner.height)];
	else [self calcDrawRect];

	if (thrusting && (timeInMS > changeTime))
	{
		changeTime = timeInMS + interval;
		frame = thrustOffset + 1 + (++thrustState & 1);
	}

	return self;
}

- calcDxDy:(NSPoint *)dp
{
	float tdecel = timeScale * DECEL;

	float thrust = [thrustVal val];
	if (thrust > 0)
	{
		if (theta < 0) xv += thrust * ACCEL;
		else xv -= thrust * ACCEL;
	}

	if (xv > MAXV) xv = MAXV;
	else if (xv < -MAXV) xv = -MAXV;

	if (xv > tdecel) xv -= tdecel;
	else if (xv < -tdecel) xv += tdecel;

	dp->x = timeScale * xv;

	dp->y = ([upVal val] - [downVal val]) * VERTSPEED;

	didFire = NO;

	return self;
}

- (void)fire
{
	if ((!employed) || didFire) return;

	{
		float oldy = y, oldx = x;
		y -= 8;
		x += (theta < 0) ? 13 : -13;
// 		[actorMgr newActor:xx_bullet for:self tag:0];
 		[actorMgr newActor:(int)[DF_Laser class] for:self tag:0];
		y = oldy, x = oldx;
	}

	didFire = YES;
}

- performCollisionWith:(Actor *) dude
{
	int i;
	float t_theta;
	id ret = self;

	if (dude->actorType == (int)[DF_People class]) return self;

	// How is he, Bones?

	[soundMgr playSound: SHIPSND at:0.5];
	t_theta = theta;
#define ZXPLOSIONS (7)
	for (i=0; i<ZXPLOSIONS; i++)
	{
		vel = randBetween(1.5,3.1);
		xv = vel * -sin(theta);
		yv = vel * cos(theta);
		t_theta += ((360./ZXPLOSIONS) * PI/180.0);
		theta = t_theta + randBetween(-6.*PI/180.,6.*PI/180.);
		[actorMgr newActor:xx_explosion for:self tag:i&1];
		
	}
	theta = 0.0;
	thrustOffset = frame = 0;
	ret = [super performCollisionWith: dude];

	return ret;
}

- scenarioSelected
{
	[keyTimerList addObject:thrustVal];
	[keyTimerList addObject:upVal];
	[keyTimerList addObject:downVal];
	return self; 
}

@end










