
#import "Defender.h"
#import "BackView.h"
#import "ActorMgr.h"
#import "CacheManager.h"
#import "xoxDefs.h"
#import "Thinker.h"
#import "../CommonEffects.bproj/SpaceGen.h"
#import "DF_Ship.h"
#import "DF_Alien.h"
#import "DF_Ground.h"
#import "DF_People.h"
#import "../CommonEffects.bproj/GOLetter.h"

// cache classes for speed in identifying
int	df_ship, df_alien, df_people;

@implementation Defender

// invoked only by the actor manager
- _createLevel:(int)lev
{
	NSRect r;
	int i;

	alienCount = peopleCount = restartTime = 0;

	ship = [actorMgr newActor:(int)[DF_Ship class] for:self tag:0];

	space = [actorMgr newActor:xx_space	for:self tag:0];
	[actorMgr newActor:(int)[DF_Ground class] for:self tag:0];

	r = [mainView bounds];
	[space newSize:r.size];

	for (i=0; i<50; i++)
		[actorMgr newActor:(int)[DF_Alien class] for:self tag:0];
	for (i=0; i<20; i++)
		[actorMgr newActor:(int)[DF_People class] for:self tag:0];

	[[mainView window] setTitle:@"Defender"];

	return self;
}

- infoView
{
	return infoView;
}

- didActivate:(Actor *)theActor
{
	if(theActor->actorType == df_alien)
		alienCount++;
	else if(theActor->actorType == df_people)
		peopleCount++;
	return self;
}

- didRetire:(Actor *)theActor
{
	if(theActor->actorType == df_ship && 
			[actorMgr gameStatus] != GAME_DYING)
	{
		[actorMgr setGameStatus: GAME_DYING];
		restartTime = timeInMS + 4200;
	}
	else if(theActor->actorType == df_alien)
	{
		if (--alienCount <= 0)
		{
			[actorMgr setGameStatus: GAME_DYING];
			restartTime = timeInMS + 2500;
		}
	}
	else if(theActor->actorType == df_people)
	{
		if (--peopleCount <= 0)
		{
			[GOLetter gameOver:self];
			[actorMgr setGameStatus: GAME_DYING];
			[actorMgr destroyActor:ship];
		}
	}
	return self;
}

- (void)keyDown:(NSEvent *)theEvent 
{
  NSString *theKeys = [theEvent characters];
  char keyBuf[2];

  [theKeys getCString:keyBuf maxLength:1];
  if ([theEvent isARepeat] > 0) return;

  switch(*keyBuf)
	{
		case 'a':		// rotate left
			[ship setElevation:LEFT down:YES time:[theEvent timestamp]];
			break;
		case 'z':		// rotate right
			[ship setElevation:RIGHT down:YES time:[theEvent timestamp]];
			break;

		case '.':		// fire
			[ship fire];
			break;
		case ',':		// thrust
			[ship setThrusting:YES time:[theEvent timestamp]];
			break;
		case ' ':		// shields
			[ship turn];
			break;
	}
}

- (void)keyUp:(NSEvent *)theEvent 
{
  NSString *theKeys = [theEvent characters];
  char keyBuf[2];

  [theKeys getCString:keyBuf maxLength:1];
  if ([theEvent isARepeat] > 0) return;

  switch(*keyBuf)
	{
		case 'a':		// rotate left
			[ship setElevation:LEFT down:NO time:[theEvent timestamp]];
			break;
		case 'z':		// rotate right
			[ship setElevation:RIGHT down:NO time:[theEvent timestamp]];
			break;
		case ',':		// thrust
			[ship setThrusting:NO time:[theEvent timestamp]];
			break;
	}
}

- scenarioSelected
{
	ship = [actorMgr newActor:(int)[DF_Ship class] for:self tag:0];
	[ship scenarioSelected];
	return self; 
}

- scenarioDeselected
{	return self; }

- init
{
  NSString *path;
	[super init];

	if (path = [[NSBundle bundleForClass:[self class]] pathForResource:@"defender" ofType:@"nib"])
	{
		[NSBundle loadNibFile:path externalNameTable:[NSDictionary dictionaryWithObjectsAndKeys:self, @"NSOwner", nil] withZone:[self zone]];
	}

	// make sure +initialize gets called
	df_ship = (int)[DF_Ship class];

	df_alien = (int)[DF_Alien class];
	df_people = (int)[DF_People class];

	return self;
}

- (COLLISION_PARADIGM)collisionParadigm
{
	return GOOD_V_EVIL;
}



- (BOOL)newWindowContentSize:(NSSize *)s
{
	BOOL ret = NO;

	if (s->width < 500) { s->width = 500; ret = YES; }
	if (s->height < 400) { s->height = 400; ret = YES; }

	return ret;
}

- newSize:(NSSize)s
{
	[space newSize:s];
	return self;
}

- oneStep
{
	if (restartTime && (timeInMS > restartTime))
	{
		[actorMgr setGameStatus: GAME_RUNNING];
		[actorMgr requestLevel:1];
	}
	return self;
}


@end




