//
//  GameInfo.m
//
//	a simple storage class that holds all the information Xox needs
//  about each game.  This file contains 2 classes; one for the information
//  on a single module and one for a list to store those GameInfo's



#import "GameInfo.h"
#import <stdlib.h>			// for free() etc
#import <strings.h>			// for strcasecmp()
#import <objc/hashtable.h>		// for NXCopyStringBuffer()

@implementation GameInfo
- init
{	return [self initWithScenario:nil name:NULL path:NULL];
}

- initWithScenario:aScenario name:(NSString *)aName path:(NSString *)aPath
{
  [super init];
  scenario = aScenario;
  scenarioName = [aName retain];
  path = [aPath retain];
  return self;
}

- setScenario:newScenario
{
  id oldScenario = scenario;
  scenario = newScenario;
  return oldScenario;
}

- scenario
{
  return scenario;
}

- (void ) setLevel:(int)newLevel
{
  level = newLevel;
  return;
}

- (int)level
{
  return level;
}

- (GAME_STATUS) setStatus:(GAME_STATUS)newStatus
{
  GAME_STATUS oldStatus = gameStatus;
  gameStatus = newStatus;
  return oldStatus;
}

- (GAME_STATUS)status
{
  return gameStatus;
}

- (NSString *) scenarioName
{
  return scenarioName;
}

- (NSString *) path
{
  return path;
}

- (BOOL)setPath:(NSString *)p
{
  path = [p retain];
  return YES;
}

- appendPath: (NSString *)p
{
  if (altPaths)
    {
    altPaths = [[NSMutableArray alloc] init];
    }
  [altPaths addObject:p];
  return self;
}

// if the path is bogus, this will set the path to the next one from altPaths
// returns self if successful, nil if there is no additional path
- useNextPath
{
  if (altPaths) {
    [path release];
    path =[[altPaths lastObject] retain];
    [altPaths removeLastObject];
    return self;
  }
  return nil;
}

- discardAltPaths
{
  [altPaths release];
  altPaths = nil;
  return self;
}

- (void)dealloc
{
  [scenario release];
  [scenarioName release];
  [path release];
  [altPaths release];
  [super dealloc];
}

@end

