/*  
 * 
 * KB_InfoBomber.m	-- An actor for displaying the bomber
 *                         in the introduction screen.
 * 
 * 
 * You may freely copy, distribute, and reuse the code in this example.
 * The author disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 *
 * Written by Mark G. Tacchi, mtacchi@next.com
 *
 * Wed Jul 27 1994
 */
 
#import "ActorMgr.h"
#import "KaBLAMDefs.h"
#import "KB_InfoBomber.h"
#import "SoundMgr.h"
#import "Actor.h"


@implementation KB_InfoBomber
- activate:sender :(int)tag
{
  NSSize tSize = {INFOBOMBER_WIDTH, INFOBOMBER_HEIGHT};
  NSSize tsizeByTwo = {INFOBOMBER_HALF_WIDTH, INFOBOMBER_HALF_HEIGHT};

  [super activate:sender :tag];
  [self reinitWithImage:@"kb_infoBomber"
		frameSize:&tSize
		numFrames:1
		shape: RECT
		alliance: NEUTRAL
		radius: 0.0
		buffered: YES
		x: 2.0
		y: 0.0
		theta: 0.0
		vel: 0.0
		interval: 2000
		distToCorner: &tsizeByTwo];
		
  expireTime= timeInMS + 15000;
  xv= 0;	yv= 0;
  
  hand= [actorMgr newActor:kb_infoBomberHand for:self tag:NEUTRAL];
  
  return self;
} /*activate::*/



- positionChanged
{
  if (timeInMS>expireTime) {
    [actorMgr newActor:xx_explosion for:self tag:0];
    [actorMgr newActor:kb_infoText for:self tag:NEUTRAL];
    [soundMgr playSound: EXP1SND at:0.5];
    [actorMgr destroyActor:hand];
    [actorMgr destroyActor:self];
  } /*endif*/
  
  [super positionChanged];
  
  return self;
} /*positionChanged*/



- performCollisionWith:(Actor *) theActor
{
  return self;
} /*performCollisionWith:*/



- hand { return hand; }
@end
