/*  
 * 
 * KaBLAM.m	-- A fast action, bomb dropping, bomb catching game.  This is the
 *             "controller" object.  It handles user preferences from the Xox
 *             panel.  It is responsible for the introduction screen, the demo,
 *             and creating the key actors.  Keyboard events are also caught
 *             and dispatched from here.
 * 
 * 
 * You may freely copy, distribute, and reuse the code in this example.
 * The author disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 *
 * Written by Mark G. Tacchi, mtacchi@next.com
 *
 * Wed Jul 27 1994
 */


#import "BackView.h"
#import "KaBLAM.h"
#import "KB_Player.h"
#import "KB_Bomber.h"
#import "KB_Bomb.h"
#import "KB_GameOver.h"
#import "KB_InfoBomber.h"
#import "KB_InfoBomberHand.h"
#import "KB_InfoText.h"
#import "KB_InfoBomb.h"
#import "ActorMgr.h"
#import "KaBLAMDefs.h"
#import "CacheManager.h"
#import "SoundMgr.h"


int kb_player, kb_bomber, kb_bomb, kb_gameOver, kb_infoBomber, kb_infoBomberHand, kb_infoText, kb_infoBomb;


int
                kb_explodeSnd,
                kb_catchSnd[8],
                kb_gameOverSnd,
                kb_extraGuySnd,
                kb_slideWhistleSnd;

#define DEFAULT_MOUSE_SENSITIVITY	2.0
#define DEFAULT_PLAYER_INPUT		1		//1= mouse, 0= keyboard

#define DEMO_LEVEL				12
@implementation KaBLAM

- newGame
{
  KB_Player *myPlayer;
  
  score= 0;
  [scoreCell setIntValue:0];
  [scoreCell display];
  lives= 3;
  nextBonus= 1000;
  myPlayer= (KB_Player *)player;
  gameOver= NO;
	
  if ([KB_themeSongSnd status]==NX_SoundPlaying)
    [(Sound *)KB_themeSongSnd stop];
	
  return self;
} /*newGame*/



// invoked only by the actor manager
- _createLevel:(int)lev
{
  char		title[64];
  int		i;
  
  badGuyCount= playerCount= 0;
  
  if (lev==1) {		//handle intro page
    id myBomber;
	
    [self setDemoMode: YES];
    [cacheMgr tileUsing:[[KB_Player class] imageNamed:@"kb_backgroundIntro.tiff"]];
    sprintf(title,"KaBLAM!");
    [[mainView window] setTitle:[NSString stringWithCString:title]];
	
	for (i= 0; i<20; i++)
	  [actorMgr newActor:kb_infoBomb for:self tag:i];
	myBomber= [actorMgr newActor:kb_infoBomber for:self tag:NEUTRAL];
	infoBomberHand= [myBomber hand];
  }
  else {
    [cacheMgr tileUsing:[[KB_Player class] imageNamed:@"kb_background.tiff"]];
    [self createPlayer];
    bomber= [actorMgr newActor:kb_bomber for:self tag:NEUTRAL];  
    [self setPauseForNextLevel:NO];
	
    if (demoMode)
	  sprintf(title,"KaBLAM!  -  Demo");
	else 
	  sprintf(title,"KaBLAM!  -  Level %d", lev-1);
    [[mainView window] setTitle:[NSString stringWithCString:title]];
	
  }
  
 return self;
} /*_createLevel:*/



- createPlayer
{
  player= [actorMgr newActor:kb_player for:self tag:lives];
  
  return self;
} /*createPlayer*/



- didActivate:(Actor *)theActor {
  if (theActor->actorType == kb_player) {
	//if this is demo mode, play the theme song
    if (demoMode && [KB_themeSongSnd status]!=NX_SoundPlaying && [soundMgr isSoundEnabled])
	 [KB_themeSongSnd play];
  } /*endif*/
  
  return self;
} /*didActivate:*/


- didRetire:(Actor *)theActor {return self;}


- (void)keyDown:(NSEvent *)theEvent 
{
  NSString *theKeys = [theEvent characters];
  char keyBuf[2];
  [theKeys getCString:keyBuf maxLength:1];

  if (level==1) {

    if (gameOver) [actorMgr requestLevel: 0];
      else if (*keyBuf == ' ') {
	  if (demoMode) demoMode= NO;
      [actorMgr requestLevel: level+1];
	}
	[infoBomberHand provoke];
  }
  else {
	switch(*keyBuf) {
      case 'z':		// move left
        [player moveLeft];
        break;
      case 'x':		// move right
        [player moveRight];
        break;
      case ' ':		// stop
        if (gameOver || demoMode) [actorMgr requestLevel: 0];
        else if (pauseForNextLevel && ![[bomber bombList] count])
          [actorMgr requestLevel: level+1];
        else [player moveStop];
        break;
	}
  }
} /*keyDown:*/



- (void)keyUp:(NSEvent *)theEvent 
{
  NSString *theKeys = [theEvent characters];
  char keyBuf[2];
  [theKeys getCString:keyBuf maxLength:1];
  
  switch(*keyBuf) {
    case 'z':		// left
      [player stopMoveLeft];
      break;
    case 'x':		// right
      [player stopMoveRight];
      break;
    case ' ':		//stop
      break;
  }
} /*keyUp:*/



- infoView {return infoView;}
- scenarioSelected {return self;}
- scenarioDeselected {return self;}


- (BOOL) createCollisionListsFrom: (NSMutableArray *)theActors
	good: (NSMutableArray *)goodList
	bad: (NSMutableArray *)badList
	ugly: (NSMutableArray *)uglyList
{
	Actor *act;
	int i, count = [theActors count];
	for (i=0; i<count; i++)
	{
		act = (Actor *)[theActors objectAtIndex:i];
		if ((act->x > gx + 1.25*xOffset) || (act->x < gx - 1.25*xOffset) || 
				(act->y > gy + 1.25*yOffset) || (act->y < gy - 1.25*yOffset) ||
				!act->employed)
			continue;
		switch((int)(act->alliance))
		{
			case GOOD:
				[goodList addObject:act];
				break;
			case EVIL:
				[badList addObject:act];
				break;
			case DESTROYALL:
				[uglyList addObject:act];
				break;
		}
	}
	return YES;
} /*createCollisionListsFrom:*/



- init
{
  NSString *path;
  int		i;
  id cv, subviews;

  [super init];

  if (path = [[NSBundle bundleForClass:[self class]] pathForResource:@"KaBLAM" ofType:@"nib"]) {
    [NSBundle loadNibFile:path externalNameTable:[NSDictionary dictionaryWithObjectsAndKeys:self, @"NSOwner", nil] withZone:[self zone]];
			
    cv= [uselessView contentView];
    subviews= [cv subviews];
    while ([subviews count] > 0)
      [scoreView addSubview:[subviews objectAtIndex:0]];
  } /*endif*/

  kb_player= (int)[KB_Player class];
  kb_bomber= (int)[KB_Bomber class];
  kb_bomb= (int)[KB_Bomb class];  
  kb_gameOver= (int)[KB_GameOver class];  
  
  kb_infoBomber= (int)[KB_InfoBomber class];
  kb_infoBomberHand= (int)[KB_InfoBomberHand class];
  kb_infoText= (int)[KB_InfoText class];
  kb_infoBomb= (int)[KB_InfoBomb class];

  //add sounds
  if (path = [[NSBundle bundleForClass:[self class]] pathForResource:@"kb_kablamThemeSong" ofType:@"snd"]) {
    KB_themeSongSnd= [[Sound alloc] initFromSoundfile:path];
  } /*endif*/

  kb_explodeSnd= [soundMgr addSound:@"kb_explode" sender:self];
  for (i=0; i<8; i++) {
    NSString *myString;
    myString = [NSString stringWithFormat:@"kb_catch%d",i];
    kb_catchSnd[i]= [soundMgr addSound:myString sender:self];
  } /*nexti*/
  
  kb_gameOverSnd= [soundMgr addSound:@"kb_gameOver" sender:self];
  kb_extraGuySnd= [soundMgr addSound:@"kb_extraGuy" sender:self];
  kb_slideWhistleSnd= [soundMgr addSound:@"kb_slideWhistle" sender:self];

  [self adjustSettings:self];
	
  return self;
} /*init*/



- (void)tile
{
  NSRect r;

  r = [gcontentView bounds];
  r.size.height -= KB_SCOREVIEW_HEIGHT;
  r.origin.y += KB_SCOREVIEW_HEIGHT;
  [abackView setFrame:r];
  
  r = [gcontentView bounds];
  r.size.height = KB_SCOREVIEW_HEIGHT;
  r.origin.y= 0;
  [scoreView setFrame:r];
  
  [gcontentView addSubview:abackView];
  [gcontentView addSubview:scoreView];
} /*tile*/



- adjustSettings:sender
{
  
  char *defaultValue;

  //read defaults from defaults database
#warning DefaultsConversion: If you were using NXReadDefault() to avoid searching the GLOBAL domain or to search a different domain than your app domain, you must set the NSUserDefault searchlist to the appropriate domains and use NSUserDefaults 'objectForKey:'
  if ((defaultValue= (char *) ([[NSUserDefaults standardUserDefaults] synchronize], [[[NSUserDefaults standardUserDefaults] objectForKey:@"KB_MouseSensitivity"] cString]))!=NULL) {
    mouseSensitivity= (float)atof(defaultValue);
    [mouseSensitivitySlider setIntValue:mouseSensitivity];
  }
  else
    mouseSensitivity= DEFAULT_MOUSE_SENSITIVITY;
	
#warning DefaultsConversion: If you were using NXReadDefault() to avoid searching the GLOBAL domain or to search a different domain than your app domain, you must set the NSUserDefault searchlist to the appropriate domains and use NSUserDefaults 'objectForKey:'
  if ((defaultValue= (char *) ([[NSUserDefaults standardUserDefaults] synchronize], [[[NSUserDefaults standardUserDefaults] objectForKey:@"KB_PlayerInput"] cString]))!=NULL) {
    mouseAsInput= (int)atoi(defaultValue);
    [playerInputMatrix selectCellWithTag:!mouseAsInput];
  }
  else
    mouseAsInput= DEFAULT_PLAYER_INPUT;

#warning DefaultsConversion: If you were using NXReadDefault() to avoid searching the GLOBAL domain or to search a different domain than your app domain, you must set the NSUserDefault searchlist to the appropriate domains and use NSUserDefaults 'objectForKey:'
  if ((defaultValue= (char *) ([[NSUserDefaults standardUserDefaults] synchronize], [[[NSUserDefaults standardUserDefaults] objectForKey:@"KB_HighScore"] cString]))!=NULL) {
    [highScoreCell setStringValue:[NSString stringWithCString:defaultValue]];
    [highScoreCell display];
    highScore= atoi(defaultValue);
  }
  else
    highScore= 0;

  return self;
} /*adjustSettings:*/



- gotoLevel:sender
{
  return self;
} /*gotoLevel:*/



- (int) level {
  int currentLevel;
  
  if ([self demoMode]) currentLevel= DEMO_LEVEL;
  else currentLevel= level;
  
  return currentLevel;
} /*level*/



- (BOOL)newWindowContentSize:(NSSize *)s
{
	s->width= KB_SCREENWIDTH;
	s->height= KB_SCREENHEIGHT + KB_SCOREVIEW_HEIGHT;
	
	return YES;
} /*newWindowContentSize:*/



- (COLLISION_PARADIGM)collisionParadigm { return GOOD_V_EVIL; }

- (int) lives{return lives;}

- (BOOL) windowResizable:(NSSize *)fixedSize { return NO; }



- (float) lowestBombLocation
{
  id lowestBomb= [[bomber bombList] objectAtIndex:0];
  float lowestPosition;
  
  if (!lowestBomb) lowestPosition= 0;  //seek center location if no bombs
  else lowestPosition= [lowestBomb position];
  
  return lowestPosition;
} /*lowestBombLocation*/



- (int) score { return score; }

- setScore: (int) newScore
{
  score= newScore;
  [scoreCell setIntValue:newScore];
  return self;
} /*setScore:*/



- addScore: (int) moreScore
{
  if (demoMode) return self;		//don't modify score if in demo mode
  
  score+= moreScore;
  [scoreCell setIntValue:score];
  if (score >= nextBonus) {
    if (lives<3) {
      lives++;
	  [player setNumPails: lives];
      [soundMgr playSound: kb_extraGuySnd at:0.5];
	} /*endif*/
    nextBonus += 1000;
  } /*endif*/
  
  if (score>highScore) {
    highScore= score;
    [highScoreCell setIntValue:highScore];
  } /*endif*/
  
  return self;
} /*addScore:*/



- (BOOL) pauseForNextLevel { return pauseForNextLevel;}

- setPauseForNextLevel: (BOOL) pause
{
  if (!demoMode) pauseForNextLevel= pause;
  
  return self;
} /*setPauseForNextLevel:*/



- loseLife
{
  lives--;
  level-= 2;  if (level<1) level= 1;
  if (lives<=0) {  //GAME OVER
    char buf[64];
	
    gameOver= YES; 
	[actorMgr newActor:kb_gameOver for:self tag:NEUTRAL];
    sprintf(buf,"%d", highScore);  //write out high score
#warning DefaultsConversion: [<NSUserDefaults> setObject:...forKey:...] used to be NXWriteDefault([[[NSProcessInfo processInfo] processName] cString], "KB_HighScore", buf). Defaults will be synchronized within 30 seconds after this change.  For immediate synchronization, call '-synchronize'. Also note that the first argument of NXWriteDefault is now ignored; to write into a domain other than the apps default, see the NSUserDefaults API.
    [[NSUserDefaults standardUserDefaults] setObject:[NSString stringWithCString:buf] forKey:@"KB_HighScore"];
  } /*endif*/
  
  return self;
  
} /*loseLife*/



- (float) mouseSensitivity { return mouseSensitivity; }

- setMouseSensitivity: sender
{
  char buf[64];
  
  mouseSensitivity= [sender floatValue];
  if (player) [player setMouseScale: mouseSensitivity];
  sprintf(buf,"%g", mouseSensitivity);
#warning DefaultsConversion: [<NSUserDefaults> setObject:...forKey:...] used to be NXWriteDefault([[[NSProcessInfo processInfo] processName] cString], "KB_MouseSensitivity", buf). Defaults will be synchronized within 30 seconds after this change.  For immediate synchronization, call '-synchronize'. Also note that the first argument of NXWriteDefault is now ignored; to write into a domain other than the apps default, see the NSUserDefaults API.
  [[NSUserDefaults standardUserDefaults] setObject:[NSString stringWithCString:buf] forKey:@"KB_MouseSensitivity"];
  
  return self;
} /*setMouseSensitivity:*/



- (BOOL) playerInput { return mouseAsInput; }

- setPlayerInput: sender
{
  char buf[8];

  mouseAsInput= ![[sender selectedCell] tag];
  if (player) [player setMouseAsInput: mouseAsInput];
  sprintf(buf,"%d", mouseAsInput);
#warning DefaultsConversion: [<NSUserDefaults> setObject:...forKey:...] used to be NXWriteDefault([[[NSProcessInfo processInfo] processName] cString], "KB_PlayerInput", buf). Defaults will be synchronized within 30 seconds after this change.  For immediate synchronization, call '-synchronize'. Also note that the first argument of NXWriteDefault is now ignored; to write into a domain other than the apps default, see the NSUserDefaults API.
  [[NSUserDefaults standardUserDefaults] setObject:[NSString stringWithCString:buf] forKey:@"KB_PlayerInput"];
  
  return self;
} /*setPlayerInput:*/



- (BOOL) demoMode { return demoMode; }

- setDemoMode: (BOOL) mode
{
  demoMode= mode;
  
  return self;
} /*setDemoMode:*/
@end

