
#import "PlayerBullet.h"
#import "ActorMgr.h"
#import "PlayerGun.h"
#import "Shoot.h"
#import "SBrick.h"
#import "SGunTower.h"
#import "SoundMgr.h"

@implementation PlayerBullet

- activate:sender :(int)tag
{
    NSSize tsize = {5,5};
    NSSize t2 = {2.5,2.5};
    NSRect frm;
    float xc, yc, myX, myY;
    
    frm = [mainView frame];
    [super activate:sender :tag];
    
    xc = (((Actor *)sender)->radius + 10) * -sin(((Actor *)sender)->theta);
    yc = (((Actor *)sender)->radius + 10) * cos(((Actor *)sender)->theta);
    myX = ((Actor *)sender)->x + xc;
    myY = ((Actor *)sender)->y + yc; 

    [self reinitWithImage:@"Sbullet"
	    frameSize:&tsize
	    numFrames:1
	    shape: RECTCIRC
	    alliance: DESTROYALL
	    radius: 2.5
	    buffered: YES
	    x: myX
	    y: myY
	    theta: ((Actor *)sender)->theta
	    vel: ((PlayerGun *)sender)->strength
	    interval: 0
	    distToCorner: &t2];
        
    [soundMgr playSound:SHOOTSND at:0.5];
    
    return self;
}

- positionChanged
{
    if ((x < (-xOffset * 2)) || (x > (xOffset * 2)) || (y < -yOffset)) {
	[actorMgr destroyActor:self];
	return self;
    }
    [super positionChanged];
    return self;
}

- calcDxDy:(NSPoint *)dp
{
    float myXv, myYv;
    myXv = (xv + ([scenario windSpeed] - xv) * timeScale * 0.1);
    myYv = (yv + (-9.8) * 0.2);
    [self setXvYv:myXv :myYv sync:NO];
    [super calcDxDy:dp];
    return self;
}

- performCollisionWith:(Actor *)dude
{
    id dudeclass = [dude class];
    
    if ((dudeclass == [SBrick class]) ||
    	(dudeclass == [PlayerBullet class]) ||
	(dudeclass == [SGunTower class])) {
	    [self bounceOff:dude];
	    [soundMgr playSound:FUTILITYSND at:0.5];
    } else [super performCollisionWith:dude];
    return self;
}

@end
