
#import "PlayerGun.h"
#import "PlayerBullet.h"
#import "../CommonEffects.bproj/Explosion.h"
#import "ActorMgr.h"
#import "KeyTimer.h"
#import "Shoot.h"
#import "SGunTower.h"

#define ROT_SPEED (37.0)

@implementation PlayerGun

- activate:sender :(int)tag
{
    NSSize tsize = {32,32};
    NSSize t2 = {16,16};
    NSRect frm;
    
    frm = [mainView frame];
    [super activate:sender :tag];
    [self reinitWithImage:@"Sgun"
	    frameSize:&tsize
	    numFrames:64
	    shape: RECT
	    alliance: tag 
	    radius: 16
	    buffered: YES
	    x: tag ? -xOffset + 20 : xOffset - 20
	    y: -yOffset + 20 + (randBetween(0,yOffset/2))
	    theta: 0
	    vel: 0
	    interval: 50
	    distToCorner: &t2];
	    
    [actorMgr newActor:(int)[SGunTower class] for:self tag:0];
    return self;
}

- performCollisionWith:(Actor *)dude
{
    if ([dude class] == [SGunTower class])
	return self;
    [actorMgr newActor:(int)[Explosion class] for:self tag:0];
    return [super performCollisionWith: dude];
}

- positionChanged
{
    float rotVal, inc, origTheta;

    [self calcDrawRect];
    
    inc = (2 * PI) / numFrames;
    rotVal = [scenario rotValFor:alliance];
    if (rotVal == 0)
	return self;

    origTheta = theta;
    theta += rotVal * inc;
	
    while (theta < 0) 
	theta += (2*PI);
    while (theta >= (2*PI)) 
	theta -= (2*PI);

    if ((theta > (3*PI/5)) && (theta < (7*PI/5))) {
	if ((origTheta - PI) < 0) {
	    theta = 3*PI/5;
	} else {
	    theta = 7*PI/5;
	}
    }

    frame = theta / inc;
    
    return self;
}

- fire:(float)str
{
    if (employed) {
	strength = MAX(10,str);
	[actorMgr newActor:(int)[PlayerBullet class] for:self tag:alliance];
    }
    return self;
}

@end
